/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.planar3TLabelStrat;

import java.util.Set;
import java.util.Stack;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.core.syntaxgraph.edge.Edge;
import org.maltparser.core.syntaxgraph.node.DependencyNode;
import org.maltparser.core.syntaxgraph.node.TokenNode;
import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.TransitionSystem;
import org.maltparser.parser.algorithm.planar3TLabelStrat.Planar3TLabelStratConfig;
import org.maltparser.parser.history.GuideUserHistory;
import org.maltparser.parser.history.History;
import org.maltparser.parser.history.action.ComplexDecisionAction;
import org.maltparser.parser.history.action.GuideUserAction;
import org.maltparser.parser.transition.TransitionTable;

public class Planar3TLabelStrat
extends TransitionSystem {
    protected static final int SHIFT = 1;
    protected static final int REDUCE = 2;
    protected static final int ARC = 3;

    public void apply(GuideUserAction currentAction, ParserConfiguration config) throws MaltChainedException {
        Planar3TLabelStratConfig planarConfig = (Planar3TLabelStratConfig)config;
        Stack<DependencyNode> stack = planarConfig.getStack();
        Stack<DependencyNode> input = planarConfig.getInput();
        currentAction.getAction(this.actionContainers);
        Edge e = null;
        switch (this.transActionContainer.getActionCode()) {
            case 3: {
                e = planarConfig.getDependencyStructure().addDependencyEdge(stack.peek().getIndex(), input.peek().getIndex());
                this.addEdgeLabels(e);
                break;
            }
            case 2: {
                stack.pop();
                break;
            }
            default: {
                stack.push(input.pop());
            }
        }
    }

    public GuideUserAction getDeterministicAction(GuideUserHistory history, ParserConfiguration config) throws MaltChainedException {
        Planar3TLabelStratConfig planar3TLabConfig = (Planar3TLabelStratConfig)config;
        if (planar3TLabConfig.getRootHandling() != 3 && planar3TLabConfig.getStack().peek().isRoot()) {
            return this.updateActionContainers(history, 1, null);
        }
        return null;
    }

    protected void addAvailableTransitionToTable(TransitionTable ttable) throws MaltChainedException {
        ttable.addTransition(1, "SH", false, null);
        ttable.addTransition(2, "RE", false, null);
        ttable.addTransition(3, "AR", true, null);
    }

    protected void initWithDefaultTransitions(GuideUserHistory history) throws MaltChainedException {
        ComplexDecisionAction currentAction = new ComplexDecisionAction((History)history);
        this.transActionContainer.setAction(1);
        this.transActionContainer.setAction(2);
        for (int i = 0; i < this.arcLabelActionContainers.length; ++i) {
            this.arcLabelActionContainers[i].setAction(-1);
        }
        currentAction.addAction(this.actionContainers);
    }

    public String getName() {
        return "planar 3t label strategy arc-eager";
    }

    public boolean permissible(GuideUserAction currentAction, ParserConfiguration config) throws MaltChainedException {
        currentAction.getAction(this.actionContainers);
        int trans = this.transActionContainer.getActionCode();
        Planar3TLabelStratConfig planarConfig = (Planar3TLabelStratConfig)config;
        DependencyNode stackPeek = planarConfig.getStack().peek();
        DependencyNode inputPeek = planarConfig.getInput().peek();
        DependencyStructure dg = planarConfig.getDependencyGraph();
        int rootHandling = planarConfig.getRootHandling();
        boolean singleHeadConstraint = planarConfig.requiresSingleHead();
        boolean noCoveredRootsConstraint = planarConfig.requiresNoCoveredRoots();
        boolean acyclicityConstraint = planarConfig.requiresAcyclicity();
        boolean connectednessConstraintOnReduce = planarConfig.requiresConnectednessCheckOnReduce();
        boolean connectednessConstraintOnShift = planarConfig.requiresConnectednessCheckOnShift();
        if (trans == 3 && !this.isActionContainersLabeled()) {
            return false;
        }
        if (trans == 3) {
            if (this.checkIfNodesAreRelated(dg, inputPeek.getIndex(), stackPeek.getIndex())) {
                return false;
            }
            if (acyclicityConstraint && stackPeek.findComponent().getIndex() == inputPeek.findComponent().getIndex()) {
                return false;
            }
        }
        if (trans == 2) {
            if (stackPeek.isRoot()) {
                return false;
            }
            if (!stackPeek.hasHead() && noCoveredRootsConstraint) {
                return false;
            }
            if (connectednessConstraintOnReduce) {
                DependencyNode stackPrev;
                boolean path1;
                boolean bl = path1 = stackPeek.findComponent().getIndex() == inputPeek.findComponent().getIndex();
                boolean path2 = planarConfig.getStack().size() < 2 ? false : (stackPrev = (DependencyNode)planarConfig.getStack().get(planarConfig.getStack().size() - 2)).findComponent().getIndex() == stackPeek.findComponent().getIndex();
                return path1 || path2;
            }
        }
        if (trans == 2 && !stackPeek.hasHead() && rootHandling == 1) {
            return false;
        }
        if (trans == 1 && connectednessConstraintOnShift && planarConfig.getInput().size() == 1) {
            boolean path = planarConfig.getDependencyGraph().getTokenNode(1).findComponent().getIndex() == inputPeek.findComponent().getIndex();
            return path;
        }
        return true;
    }

    public GuideUserAction defaultAction(GuideUserHistory history, ParserConfiguration configuration) throws MaltChainedException {
        return this.updateActionContainers(history, 1, null);
    }

    private boolean checkIfNodesAreRelated(DependencyStructure dg, int index1, int index2) throws MaltChainedException {
        TokenNode tk = dg.getTokenNode(index1);
        Set<DependencyNode> heads = null;
        if (tk != null) {
            heads = tk.getHeads();
            for (DependencyNode head : heads) {
                if (head.getIndex() != index2) continue;
                return true;
            }
        }
        if ((tk = dg.getTokenNode(index2)) != null) {
            heads = tk.getHeads();
            for (DependencyNode head : heads) {
                if (head.getIndex() != index1) continue;
                return true;
            }
        }
        return false;
    }
}

