/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.io;

import com.aliasi.util.Iterators;
import com.aliasi.util.Streams;
import com.aliasi.util.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLineReader
extends LineNumberReader
implements Iterable<String> {
    public FileLineReader(File file, String encoding) throws IOException {
        this(file, encoding, false);
    }

    public FileLineReader(File file, String encoding, boolean gzipped) throws IOException {
        super(FileLineReader.buildReader(file, encoding, gzipped));
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterators.Buffered<String>(){

            @Override
            public String bufferNext() {
                try {
                    return FileLineReader.this.readLine();
                }
                catch (IOException e) {
                    throw new IllegalStateException("I/O error reading", e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readLines() throws IOException {
        ArrayList<String> lineList = new ArrayList<String>();
        try {
            for (String line : this) {
                lineList.add(line);
            }
        }
        finally {
            this.close();
        }
        return lineList;
    }

    public static List<String> readLines(File in, String encoding) throws IOException, UnsupportedEncodingException {
        FileLineReader reader = new FileLineReader(in, encoding);
        return reader.readLines();
    }

    public static String[] readLineArray(File in, String encoding) throws IOException, UnsupportedEncodingException {
        List<String> lineList = FileLineReader.readLines(in, encoding);
        return lineList.toArray(Strings.EMPTY_STRING_ARRAY);
    }

    static Reader buildReader(File file, String encoding, boolean gzipped) throws IOException {
        FileInputStream in = null;
        InputStream zipIn = null;
        InputStreamReader reader = null;
        try {
            in = new FileInputStream(file);
            zipIn = gzipped ? new GZIPInputStream(in) : in;
            reader = new InputStreamReader(zipIn, encoding);
            return reader;
        }
        catch (IOException e) {
            Streams.closeReader(reader);
            Streams.closeInputStream(zipIn);
            Streams.closeInputStream(in);
            throw e;
        }
    }
}

