/*
 * Decompiled with CFR 0.152.
 */
package tsg.metrics;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import tsg.Label;
import tsg.TSNodeLabel;
import tsg.metrics.ParseMetricOptimizer;
import util.Utility;

public class MPP
extends ParseMetricOptimizer {
    Hashtable<String, double[]> treeStringProbTable;

    public MPP() {
        this.identifier = "MPP";
    }

    @Override
    protected void initSentence() {
        this.treeStringProbTable = new Hashtable();
    }

    @Override
    public void addNewDerivationChecked(TSNodeLabel tree, double prob) {
        String treeString = tree.toString();
        Utility.increaseInTableDoubleArray(this.treeStringProbTable, treeString, prob);
    }

    @Override
    public TSNodeLabel getBestTree() throws Exception {
        String bestTreeString = Utility.getMaxKey(this.treeStringProbTable);
        TSNodeLabel bestTree = new TSNodeLabel(bestTreeString);
        ArrayList<TSNodeLabel> bestTreeLex = bestTree.collectLexicalItems();
        Iterator<TSNodeLabel> iterBest = bestTreeLex.iterator();
        Label[] labelArray = this.lexicalItems;
        int n = this.lexicalItems.length;
        int n2 = 0;
        while (n2 < n) {
            Label originalLabel;
            iterBest.next().label = originalLabel = labelArray[n2];
            ++n2;
        }
        return bestTree;
    }
}

