#!/bin/bash
set -x
dir=$1
/mnt/user/E-xiaoyi.zp-102098/llm/DeepSpeedChat/applications/DeepSpeed-Chat/output/actor-models/llama13b_en2de_lora
ref=/mnt/alitranx-nas/users/xiaoyi.zp/llm/docdata/de-en/iwslt16.de
#ref = "/mnt/alitranx-nas/users/xiaoyi.zp/llm/docdata/zh-en/wmt22.en1 /mnt/alitranx-nas/users/xiaoyi.zp/llm/docdata/zh-en/wmt22.en2"
testset=/mnt/alitranx-nas/users/xiaoyi.zp/llm/docdata/iwslt17_en2de/en-de/test.split.jsonl
models=`ls -d -t  $dir/step*`
evals=$dir/evals
mkdir -p $evals

for model in $models
do
    epoch=${model##*\/}
    echo $epoch
    if [ -s $evals/trans.$epoch.trans.bleu ];
    then
        continue
        echo "continue"
    fi
    if [ ! -s  $model/convert/pytorch_model.bin ];
    then
      mkdir -p $model/convert
      python /mnt/user/E-xiaoyi.zp-102098/llm/DeepSpeedChat/applications/DeepSpeed-Chat/training/step1_supervised_finetuning/evaluation_scripts/convert_lora_model.py \
      --model_path $model/pytorch_model.bin --save_dir $model/convert --lora_dim 128
      cp $model/config.json $model/convert/
    fi
    torchrun --nproc_per_node 1  \
        /mnt/user/E-xiaoyi.zp-102098/llm/DeepSpeedChat/applications/DeepSpeed-Chat/training/step1_supervised_finetuning/prompt_eval_test.py \
        --deepspeed  --model_name_or_path_baseline /mnt/alitranx-nas/users/funan.whr/data/huggingface-models/llama-7b \
        --model_name_or_path_finetune $model/convert \
        --input $testset --language English --zero_stage 1 \
        --output $evals/trans.$epoch --per_device_batch_size 2
    python  /mnt/user/E-xiaoyi.zp-102098/tools/get_prediction.py $evals/trans.$epoch >   $evals/trans.$epoch.trans
    cat  $evals/trans.$epoch.trans  |  sacrebleu -l en-de  $ref -lc > $evals/trans.$epoch.trans.bleu_lc
    cat  $evals/trans.$epoch.trans | sacrebleu -l en-de  $ref  > $evals/trans.$epoch.trans.bleu
done

