import numpy as np


def compute_num_correct(answers_true, answers_pred, eva_mode):
    assert len(answers_true) == len(answers_pred)

    if isinstance(answers_true[0], str):
        num_correct = int((np.asarray(answers_true) == np.asarray(answers_pred)).sum())

    elif isinstance(answers_true[0], list):
        num_correct = 0
        for i, ans_list in enumerate(answers_true):
            ans_pred = answers_pred[i]
            ans_pred = ans_pred if isinstance(ans_pred, list) else [ans_pred]

            # if at least one is correct.
            if set(ans_list) & set(ans_pred):
                num_correct += 1

    else:
        raise NotImplementedError

    return num_correct
