theory question_63_1

imports Main

begin

typedecl entity
typedecl event

consts
  SedimentaryRocks :: "entity ⇒ bool"
  Sandstone :: "entity ⇒ bool"
  Deposition :: "event ⇒ bool"
  Formed :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation Sentence: Sedimentary rocks, which include sandstone, are formed by deposition. *)
axiomatization where
  explanation_1: "∀x. SedimentaryRocks x ⟶ (∃y e. Deposition y ∧ Formed e ∧ Agent e y ∧ Patient e x) ∧ (∃z. Sandstone z ∧ Patient e z)"

(* Explanation Sentence: Sandstone is a specific type of sedimentary rock that is formed by deposition. *)
axiomatization where
  explanation_2: "Sandstone x ⟶ (∃y e. SedimentaryRocks x ∧ Deposition y ∧ Formed e ∧ Agent e y ∧ Patient e x)"

theorem hypothesis:
  assumes asm: "Rocks x ∧ Deposition y ∧ Formed e ∧ Agent e y ∧ Patient e x"
  (* Hypothesis: Rocks formed by deposition are sandstone. *)
  shows "Sandstone x"
proof -
  from asm have "SedimentaryRocks x" using explanation_1 by blast
  then have "Sandstone x" using explanation_2 by blast
  then show "Sandstone x" by simp
qed

end
