theory question_81_0
imports Main

begin

typedecl entity
typedecl event

consts
  Bike :: "entity ⇒ bool"
  Bicycle :: "entity ⇒ bool"
  Person :: "entity ⇒ bool"
  SoaringOverTheGround :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Outside :: "entity ⇒ bool"
  Helmet :: "entity ⇒ bool"
  Wears :: "event ⇒ bool"
  InFrontOf :: "entity ⇒ entity ⇒ bool"
  Jumps :: "event ⇒ bool"

(* Explanation 1: Bike is the short word for bicycle, and the person is outside if the person is soaring over the ground. *)
axiomatization where
  explanation_1: "∀x. Bike x ⟷ Bicycle x"
   "∀x y z e. (Person x ∧ SoaringOverTheGround e ∧ Agent e x ∧ Patient e z) ⟶ Outside x"

theorem hypothesis:
  (* Premise: A person on a bicycle wears a helmet and jumps, soaring over the ground in front of a skyline and lake. *)
  assumes asm: "Person x ∧ Bicycle y ∧ Helmet z ∧ Wears e1 ∧ Agent e1 x ∧ Patient e1 z ∧ Jumps e2 ∧ Agent e2 x ∧ SoaringOverTheGround e2 ∧ InFrontOf y  Skyline ∨ Lake "
  (* Hypothesis: A person outside with a bike. *)
  shows "∃x y e. Person x ∧ Bike y ∧ Wears e ∧ Agent e x ∧ Patient e y ∧ Outside x"
proof -
  from asm have "Person x" "Bicycle y" "InFrontOf y Skyline ∨ Lake" "SoaringOverTheGround (Jumps e2)" "Agent e2 x" "Patient e2 y" using explanation_1(2) by auto
  then have "Outside x" using explanation_1(2) by blast
  have "Bike y" using explanation_1(1) by blast
  have "Wears e1" "Agent e1 x" "Patient e1 z" using asm by blast
  then have "Person x" "Bike y" "Wears e1" "Agent e1 x" "Patient e1 y" "Outside x" using explanation_1(1) by blast
  then show ?thesis by blast
qed

end
