theory question_89_0

imports Main

begin

typedecl entity
typedecl event

consts
  Muscles :: "entity ⇒ bool"
  Can :: "event ⇒ bool"
  Contract :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  ArmDay :: "entity ⇒ bool"
  Hit :: "event ⇒ bool"
  Bicep :: "entity ⇒ bool"
  Tricep :: "entity ⇒ bool"
  ForearmMuscles :: "entity ⇒ bool"

(* Explanation 1: Muscles can only contract. *)
axiomatization where
  explanation_1: "∀x e. Muscles x ∧ Can e ∧ Contract e ∧ Agent e x"

(* Explanation 2: Arm day hits the bicep, tricep and forearm muscles. *)
axiomatization where
  explanation_2: "∀x e. ArmDay x ∧ Hit e ∧ Bicep x ∧ Tricep x ∧ ForearmMuscles x ∧ Agent e x"

theorem hypothesis:
  assumes asm: "Triceps x"
  (* Hypothesis: Triceps can only contract. *)
  shows "∃x e. Triceps x ∧ Can e ∧ Contract e ∧ Agent e x"
proof -
  from asm have "Triceps x" by simp
  then obtain e1 where e1: "Muscles x ∧ Can e1 ∧ Contract e1 ∧ Agent e1 x" using explanation_1 by blast
  then have "Bicep x ∧ Tricep x ∧ ForearmMuscles x" using explanation_2 by blast
  have conclusion: "Triceps x ∧ Can e1 ∧ Contract e1 ∧ Agent e1 x" using e1 by simp
  show ?thesis using asm conclusion `Bicep x ∧ Tricep x ∧ ForearmMuscles x` by blast
qed

end
