theory question_81_9

imports Main

begin

typedecl entity
typedecl event

consts
  Soil :: "entity ⇒ bool"
  Environments :: "entity ⇒ bool"
  Forest :: "entity ⇒ bool"
  TypicallyNonliving :: "entity ⇒ entity ⇒ bool"
  Component :: "entity ⇒ entity ⇒ bool"
  SpecificallyNonlivingPart :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Soil is typically a nonliving component of environments, such as forests, and specifically a nonliving part of a forest. *)
axiomatization where
  explanation_1: "∀x y z. Soil x ∧ Environments y ∧ Forest z ⟶ (TypicallyNonliving x y ∧ Component x y ∧ SpecificallyNonlivingPart x z)"

theorem hypothesis:
  assumes asm: "Soil x ∧ Forest y"
  (* Hypothesis: Soil is a nonliving part of a forest. *)
  shows "NonlivingPart x y"
proof -
  from asm have "Soil x" by simp
  from asm have "Forest y" by simp
  then have "TypicallyNonliving x y ∧ Component x y ∧ SpecificallyNonlivingPart x y" using explanation_1 by blast
  then have "SpecificallyNonlivingPart x y" by blast
  then show ?thesis using `Soil x` `Forest y` by blast
qed

end
