theory question_89_4
imports Main

begin
typedecl entity
typedecl event

consts
  MountainBiking :: "entity ⇒ bool"
  RecreationalActivity :: "entity ⇒ bool"
  Autumn :: "entity ⇒ bool"
  Practiced :: "entity ⇒ entity ⇒ bool"
  Season :: "entity ⇒ bool"
  KnownFor :: "entity ⇒ bool"
  Enjoyed :: "entity ⇒ entity ⇒ bool"
  Bicycling :: "entity ⇒ bool"
  Woods :: "entity ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"
  Forest :: "entity ⇒ bool"
  EarlyFall :: "entity ⇒ bool"

(* Explanation 1: Mountain biking is a popular recreational activity during autumn. *)
axiomatization where
  explanation_1: "∀x y z. MountainBiking x ∧ RecreationalActivity y ∧ Autumn z ⟶ Practiced x z"

(* Explanation 2: Autumn is a season where mountain biking is frequently practiced. *)
axiomatization where
  explanation_2: "∀x y z. Autumn x ∧ Season y ∧ MountainBiking z ⟶ Practiced z x"

(* Explanation 3: Autumn is known for being a time when mountain biking is widely enjoyed. *)
axiomatization where
  explanation_3: "∀x y z. Autumn x ∧ KnownFor y ∧ MountainBiking z ⟶ Enjoyed z x"

theorem hypothesis:
  (* Premise: Mountain biking in a forest during the early fall. *)
  assumes asm: "MountainBiking x ∧ Forest y ∧ EarlyFall z ∧ In x y ∧ In x z"
  (* Hypothesis: Bicycling through the woods in the Autumn. *)
  shows "∃x y z e. Bicycling x ∧ Woods y ∧ Autumn z ∧ In x y ∧ In x z"
proof -
  from asm have "MountainBiking x ∧ Forest y ∧ EarlyFall z" by blast
  then have "RecreationalActivity x ∧ Autumn z" using explanation_1 by blast
  then have "Bicycling x ∧ Woods y ∧ Autumn z" by blast
  then show ?thesis using `Bicycling x` `Woods y` `Autumn z` by blast
qed

end
