import logging.config
from pathlib import Path
from typing import Type

from omegaconf import OmegaConf
from pydantic import BaseModel

logger = logging.getLogger(__name__)


def load_config(config_path: Path, class_type: Type[BaseModel]) -> BaseModel:
    conf = OmegaConf.load(config_path)
    # resolve to container i.e. a dict, to allow to specify lists and dicts
    # within app_config.yaml

    conf_dict = OmegaConf.to_container(conf, resolve=True)

    config = class_type.model_validate(conf_dict)
    logger.info(config.model_dump_json(indent=4))
    return config


def setup_logging(config_path: Path):
    """
    Setup logging config.
    """
    conf = OmegaConf.load(config_path)
    conf_dict = OmegaConf.to_container(conf, resolve=True)
    logging.config.dictConfig(conf_dict)
