import getpass
from datetime import datetime
from enum import IntEnum, auto
from pathlib import Path

_block_extension: str = ".bin"
_metadata_file_name: str = "metadata.json"
_timestamp: str = lambda: str(datetime.now().timestamp() * 10)
_cache_path: Path = Path(f"/home/{getpass.getuser()}/.hedal")

temp_path: Path = lambda: _cache_path / _timestamp()
parent_path: Path = lambda obj: obj.path.parent
name: str = lambda obj: obj.path.parts[-1]
metadata_path: Path = lambda obj: obj.path / _metadata_file_name
scaler_path: Path = lambda obj: obj.path / "scale"
block_path: str = lambda obj, idx: f"{obj.path}/block_{idx}{_block_extension}"


class PackingType(IntEnum):
    FRAME = auto()
    MATRIX = auto()


class ScaleType(IntEnum):
    NORMAL = auto()  # do not scale
    MINMAX = auto()  # minmax normalization
    STNDRD = auto()  # standard normalization
