import argparse
import csv
import json


def main(args):
    with open(args.input, 'r') as f, open(args.output, 'w') as g:
        reader = csv.DictReader(f, delimiter='\t', quoting=csv.QUOTE_NONE)
        for idx, line in enumerate(reader):
            output = {'label': line[args.label_field]}
            if args.inputs:
                for field in args.inputs:
                    output[field] = line[field]
            else:
                output.update(line.items())
            output['idx'] = idx
            print(json.dumps(output, ensure_ascii=False), file=g)


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('input', type=str)
    parser.add_argument('output', type=str)
    parser.add_argument('--label_field', type=str, default='label')
    parser.add_argument('--inputs', type=str, nargs='+')
    args = parser.parse_args()

    main(args)

