import json

# quality:grammar/Natural/Understandable/Correct/Fluent
NUF = [("persona-usr", "Natural"),
       ("topical-usr", "Natural"),
       ("dailydialog-zhao", "grammar"),
       ("persona-usr", "Understandable"),
       ("topical-usr", "Understandable"),
       ("fed-turn", "Correct"),
       ("fed-turn", "Understandable"),
       ("fed-turn", "Fluent")]

# quality:relevance/Semantically appropriate/Maintains Context
CR = [("dailydialog-zhao", "relevance"),
      ("persona-usr", "Maintains Context"),
      ("topical-usr", "Maintains Context"),
      ("fed-turn", "Relevant"),
      ("fed-turn", "Semantically appropriate"),
      ("convai2-grade", "relevance"),
      ("empathetic-grade", "relevance"),
      ("dailydialog-grade", "relevance"),
      ("dstc7", "relevance"),
      ("humod", "relevance")]

# quality:content/Engaging/Interesting/informativeness/Specific
IES = [("dailydialog-zhao", "content"),
       ("persona-usr", "Engaging"),
       ("topical-usr", "Engaging"),
       ("fed-turn", "Interesting"),
       ("fed-turn", "Engaging"),
       ("fed-turn", "Specific"),
       ("dstc7", "informativeness")]

# quality:overall
Overall = [("dailydialog-gupta", "overall"),
           ("dailydialog-zhao", "overall"),
           ("persona-usr", "Overall"),
           ("topical-usr", "Overall"),
           ("persona-zhao", "overall"),
           ("fed-turn", "Overall"),
           ("dstc6", "overall"),
           ("dstc7", "overall")]

#      usr 的数据Understandable (0 - 1):Natural (1 - 3） Interesting (1 - 3)；Maintains Context (1 - 3)
quality_category = [("NUF", NUF), ("CR", CR), ("IES", IES), ("Overall", Overall)]  # 四大quality类别
ctx = []
res = []
anno = []

for quality_name, now_category in quality_category:

    for dataset, quality in now_category:  # NUF---("persona-usr", "Natural"),
        f = open("../dstc10-split-by-dialog-score/{}/{}_all_ctx.txt".format(dataset, dataset), "r", encoding="utf-8")
        for line in f:
            ctx.append(line)
        f.close()

        f = open("../dstc10-split-by-dialog-score/{}/{}_all_res.txt".format(dataset, dataset), "r", encoding="utf-8")
        for line in f:
            res.append(line)
        f.close()

        with open("../dstc10-split-by-dialog-score/{}/{}_all_anno.json".format(dataset, dataset), "r") as f:
            json_data = json.load(f)

            for sample in json_data:
                anno_list = sample[quality]
                for idx, single_anno in enumerate(anno_list):
                    if (dataset == "persona-usr") | (dataset == "topical-usr"):
                        if quality == "Understandable":
                            anno_list[idx] = single_anno * 4
                        if quality == "Natural":
                            anno_list[idx] = single_anno * 2 - 1
                        if quality == "Interesting":
                            anno_list[idx] = single_anno * 2 - 1
                        if quality == "Maintains Context":
                            anno_list[idx] = single_anno * 2 - 1

                now_score = int(sum(anno_list) / len(anno_list))
                if (now_score == 0):
                    now_score = 1
                anno.append(now_score)


    with open("{}/ctx.txt.".format(quality_name), 'w', encoding="utf-8") as f:
        for i in ctx:
            f.write(str(i))
    with open("{}/res.txt.".format(quality_name), 'w', encoding="utf-8") as f:
        for i in res:
            f.write(str(i))
    with open("{}/anno.txt.".format(quality_name), 'w', encoding="utf-8") as f:
        for i in anno:
            f.write(str(i) + '\n')
    ctx.clear()
    res.clear()
    anno.clear()

num = 0
with open("Overall/anno.txt",'r') as f:
    for i in f:
        if int(i) == 4:
            num = num + 1

print(num)