import os
import sys
import numpy as np

# read in data
data = [l.strip('\n') for l in open(sys.argv[1])]

ems = {'ORG':{'TOP25':[], 'TOP50':[], 'TOP75':[], 'TOP100':[], 'except_TOP1':[], 'except_TOP3':[], 'except_TOP5':[]}, 'SUB':{'TOP25':[], 'TOP50':[], 'TOP75':[], 'TOP100':[], 'except_TOP1':[], 'except_TOP3':[], 'except_TOP5':[]}}

# start parsing
assert (len(data) % 2 == 0)
paired_data = []

inst = []
for i, l in enumerate(data):
    inst.append(l)
    # odd
    if i % 2 == 1:
        if len(inst) == 2:
            paired_data.append(inst)
            inst = []

for inst in paired_data:
    org_label = inst[0].split(']')[0].split(' ')[0][1:]
    topk_label = inst[0].split(']')[1].strip().split(' ')[1]
    acc = float(inst[1].split('|')[0].strip().split('Acc: ')[1])
    ems[org_label][topk_label].append(acc)


for org_label in ['ORG', 'SUB']:
    for k, v in ems[org_label].items():
        if v:
            print('%s | %s | %f'%(org_label, k, sum(v)/len(v)))

for topk_label in ['TOP25', 'TOP50', 'TOP75', 'TOP100']:
    if ems['ORG'][topk_label]:
        org = ems['ORG'][topk_label]
        sub = ems['SUB'][topk_label]
        org = sum(org)/len(org)
        sub = sum(sub)/len(sub)
        print('%s | M_R: %f'%(topk_label, org/(org+sub)))
        


