# Examples

Also check out our [Guides](../guides) to learn more about `jiant`.

## Example Notebooks

### Simple Fine-tuning

* **Fine-tuning on a single task with the simple API** [[Notebook](./notebooks/simple_api_fine_tuning.ipynb)] [[Colab](https://colab.research.google.com/github/nyu-mll/jiant/blob/master/examples/notebooks/simple_api_fine_tuning.ipynb)]
* **Fine-tuning on a single task with the main API** [[Notebook](./notebooks/jiant_Basic_Example.ipynb)] [[Colab](https://colab.research.google.com/github/nyu-mll/jiant/blob/master/examples/notebooks/jiant_Basic_Example.ipynb)]

### Intermediate use cases

* **Multi-task Training** [[Notebook](./notebooks/jiant_Multi_Task_Example.ipynb)] [[Colab](https://colab.research.google.com/github/nyu-mll/jiant/blob/master/examples/notebooks/jiant_Multi_Task_Example.ipynb)]
    * Fine-tuning on multiple tasks simultaneously
* **STILTs Training** [[Notebook](./notebooks/jiant_STILTs_Example.ipynb)] [[Colab](https://colab.research.google.com/github/nyu-mll/jiant/blob/master/examples/notebooks/jiant_STILTs_Example.ipynb)]
    * Fine-tuning on multiple tasks sequentially
* **Zero-shot transfer to XNLI** [[Notebook](./notebooks/jiant_XNLI_Example.ipynb)] [[Colab](https://colab.research.google.com/github/nyu-mll/jiant/blob/master/examples/notebooks/jiant_XNLI_Example.ipynb)]
    * Fine-tuning on MNLI for zero-shot transfer to XNLI
* **MNLI-mismatched/GLUE Diagnostic** [[Notebook](./notebooks/jiant_MNLI_Diagnostic_Example.ipynb)] [[Colab](https://colab.research.google.com/github/nyu-mll/jiant/blob/master/examples/notebooks/jiant_MNLI_Diagnostic_Example.ipynb)]
   * Fine-tuning on MNLI for MNLI-mismatched and GLUE Diagnostic set
