# -*- coding: utf-8 -*-

from abc import ABCMeta, abstractmethod

import torch.nn as nn

from ..data.dataset import DataFeatures


class InputPluginBase(nn.Module, metaclass=ABCMeta):
    @abstractmethod
    def postprocess_sample(self, sample: DataFeatures, **kwargs):
        pass

    @abstractmethod
    def postprocess_batch(self, batch_samples, inputs):
        pass

    @abstractmethod
    def forward(self, inputs):
        pass
