def get_relation_metadata(docs):
    type_list = []
    subtype_list = []
    role_list = []
    for doc in docs:
        for mention_id in doc.evaluator_ere.relation_mentions:
            mention = doc.evaluator_ere.relation_mentions[mention_id]

            arg1_role = mention.rel_arg1.role
            arg2_role = mention.rel_arg2.role
            relation_type = mention.relation.relation_type
            relation_subtype = mention.relation.relation_subtype

            if relation_type not in type_list:
                type_list.append(relation_type)
            if relation_subtype not in subtype_list:
                subtype_list.append(relation_subtype)
            if arg1_role not in role_list:
                role_list.append(arg1_role)
            if arg2_role not in role_list:
                role_list.append(arg2_role)

    return type_list, subtype_list, role_list


def get_event_metadata(docs):
    type_list = []
    subtype_list = []
    role_list = []
    for doc in docs:
        for mention_id in doc.evaluator_ere.event_mentions:
            mention = doc.evaluator_ere.event_mentions[mention_id]

            event_type = mention.event_type
            event_subtype = mention.event_subtype
            if event_type not in type_list:
                type_list.append(event_type)
            if event_subtype not in subtype_list:
                subtype_list.append(event_subtype)

            for arg_id in mention.arguments:
                argument = mention.arguments[arg_id]
                role = argument.role
                if role not in role_list:
                    role_list.append(role)

    return type_list, subtype_list, role_list
