/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.tregex.TregexPatternCompiler;
import edu.stanford.nlp.util.Generics;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class EnglishGrammaticalRelations {
    private static final String timeWordRegex = "/^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/";
    private static final String timeWordLotRegex = "/^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter|lot)$/";
    static final String copularWordRegex = "/^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/";
    static final String clausalComplementRegex = "/^(?i:seem|seems|seemed|seeming|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/";
    private static final String passiveAuxWordRegex = "/^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|become|becomes|became|becoming|get|got|getting|gets|gotten|remains|remained|remain)$/";
    private static final String beAuxiliaryRegex = "/^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase)$/";
    private static final String haveRegex = "/^(?i:have|had|has|having|'ve|ve|v|'d|d|hvae|hav|as)$/";
    private static final String stopKeepRegex = "/^(?i:stop|stops|stopped|stopping|keep|keeps|kept|keeping)$/";
    private static final TregexPatternCompiler tregexCompiler = new TregexPatternCompiler((HeadFinder)null);
    public static final GrammaticalRelation PREDICATE = new GrammaticalRelation(GrammaticalRelation.Language.English, "pred", "predicate", PredicateGRAnnotation.class, GrammaticalRelation.DEPENDENT, "S|SINV", tregexCompiler, new String[]{"S|SINV <# VP=target"});
    public static final GrammaticalRelation AUX_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "aux", "auxiliary", AuxModifierGRAnnotation.class, GrammaticalRelation.DEPENDENT, "VP|SQ|SINV|CONJP", tregexCompiler, new String[]{"VP < VP < /^(?:TO|MD|VB.*|AUXG?|POS)$/=target", "SQ|SINV < (/^(?:VB|MD|AUX)/=target $++ /^(?:VP|ADJP)/)", "CONJP < TO=target < VB", "SINV < (VP=target < (/^(?:VB|AUX|POS)/ < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase)$/) $-- (VP < VBG))"});
    public static final GrammaticalRelation AUX_PASSIVE_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "auxpass", "passive auxiliary", AuxPassiveGRAnnotation.class, AUX_MODIFIER, "VP|SQ|SINV", tregexCompiler, new String[]{"VP < (/^(?:VB|AUX|POS)/=target < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|become|becomes|became|becoming|get|got|getting|gets|gotten|remains|remained|remain)$/ ) < (VP|ADJP [ < VBN|VBD | < (VP|ADJP < VBN|VBD) < CC ] )", "SQ|SINV < (/^(?:VB|AUX|POS)/=target < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase)$/ $++ (VP < VBD|VBN))", "SINV < (VP=target < (/^(?:VB|AUX|POS)/ < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase)$/) $-- (VP < VBD|VBN))", "SINV < (VP=target < (VP < (/^(?:VB|AUX|POS)/ < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase)$/)) $-- (VP < VBD|VBN))"});
    public static final GrammaticalRelation COPULA = new GrammaticalRelation(GrammaticalRelation.Language.English, "cop", "copula", CopulaGRAnnotation.class, AUX_MODIFIER, "VP|SQ|SINV|SBARQ", tregexCompiler, new String[]{"VP < (/^(?:VB|AUX)/=target < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/ [ $++ (/^(?:ADJP|NP$|WHNP$)/ !< VBN|VBD) | $++ (S <: (ADJP < JJ)) ] )", "SQ|SINV < (/^(?:VB|AUX)/=target < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/ [ $++ (ADJP !< VBN|VBD) | $++ (NP $++ NP) | $++ (S <: (ADJP < JJ)) ] )", "SBARQ < (/^(?:VB|AUX)/=target < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/) < (WHNP < WP)"});
    public static final GrammaticalRelation CONJUNCT = new GrammaticalRelation(GrammaticalRelation.Language.English, "conj", "conjunct", ConjunctGRAnnotation.class, GrammaticalRelation.DEPENDENT, "VP|(?:WH)?NP(?:-TMP|-ADV)?|ADJP|PP|QP|ADVP|UCP(?:-TMP|-ADV)?|S|NX|SBAR|SBARQ|SINV|SQ|JJP|NML|RRC", tregexCompiler, new String[]{"VP|S|SBAR|SBARQ|SINV|SQ|RRC < (CC|CONJP $-- !/^(?:``|-LRB-|PRN|PP|ADVP|RB)/ $+ !/^(?:PRN|``|''|-[LR]RB-|,|:|\\.)$/=target)", "VP|S|SBAR|SBARQ|SINV|SQ|RRC < (CC|CONJP $-- !/^(?:``|-LRB-|PRN|PP|ADVP|RB)/ $+ (ADVP $+ !/^(?:PRN|``|''|-[LR]RB-|,|:|\\.)$/=target))", "VP|S|SBAR|SBARQ|SINV|SQ=root < (CC|CONJP $-- !/^(?:``|-LRB-|PRN|PP|ADVP|RB)/) < (/^(?:PRN|``|''|-[LR]RB-|,|:|\\.)$/ $+ (/^S|SINV$|^(?:A|N|V|PP|PRP|J|W|R)/=target [$-- (/^CC|CONJP$/ $-- (__ ># =root) !$++ (/^:|,$/ $++ =target)) | $-- (/^:|,$/ $-- (__ ># =root) [!$-- /^CC|CONJP$/ | $++ (=target < (/^,$/ $++ (__ ># =target)))])] ) )", "/^(?:ADJP|JJP|PP|QP|(?:WH)?NP(?:-TMP|-ADV)?|ADVP|UCP(?:-TMP|-ADV)?|NX|NML)$/ < (CC|CONJP $-- !/^(?:``|-LRB-|PRN)$/ $+ !/^(?:PRN|``|''|-[LR]RB-|,|:|\\.)$/=target)", "/^(?:ADJP|PP|(?:WH)?NP(?:-TMP|-ADV)?|ADVP|UCP(?:-TMP|-ADV)?|NX|NML)$/ < (CC|CONJP $-- !/^(?:``|-LRB-|PRN)$/ $+ (ADVP $+ !/^(?:PRN|``|''|-[LR]RB-|,|:|\\.)$/=target))", "/^(?:ADJP|PP|(?:WH)?NP(?:-TMP|-ADV)?|ADVP|UCP(?:-TMP|-ADV)?|NX|NML)$/ < (CC|CONJP $-- !/^(?:``|-LRB-|PRN)$/) < (/^(?:PRN|``|''|-[LR]RB-|,|:|\\.)$/ $+ /^S|SINV$|^(?:A|N|V|PP|PRP|J|W|R)/=target)", "NX|NML < (CC|CONJP $- __) < (/^,$/ $- /^(?:A|N|V|PP|PRP|J|W|R|S)/=target)", "/^(?:VP|S|SBAR|SBARQ|SINV|ADJP|PP|QP|(?:WH)?NP(?:-TMP|-ADV)?|ADVP|UCP(?:-TMP|-ADV)?|NX|NML)$/ < (CC $++ (CC|CONJP $+ !/^(?:PRN|``|''|-[LR]RB-|,|:|\\.)$/=target))"});
    public static final GrammaticalRelation COORDINATION = new GrammaticalRelation(GrammaticalRelation.Language.English, "cc", "coordination", CoordinationGRAnnotation.class, GrammaticalRelation.DEPENDENT, ".*", tregexCompiler, new String[]{"__ [ < (CC=target !< /^(?i:either|neither|both)$/ ) | < (CONJP=target !< (RB < /^(?i:not)$/ $+ (RB|JJ < /^(?i:only|just|merely)$/))) ]"});
    public static final GrammaticalRelation PUNCTUATION = new GrammaticalRelation(GrammaticalRelation.Language.English, "punct", "punctuation", PunctuationGRAnnotation.class, GrammaticalRelation.DEPENDENT, ".*", tregexCompiler, new String[]{"__ < /^(?:\\.|:|,|''|``|\\*|-LRB-|-RRB-|HYPH)$/=target", "__ < (NFP=target !< /^(?:[<>]?[:;=8][\\-o\\*']?(?:-RRB-|-LRB-|[DPdpO\\/\\\\\\:}{@\\|\\[\\]])|(?:-RRB-|-LRB-|[DPdpO\\/\\\\\\:}{@\\|\\[\\]])[\\-o\\*']?[:;=8][<>]?)$/!< /^(?:-LRB-)?[\\-\\^x=~<>'][_.]?[\\-\\^x=~<>'](?:-RRB-)?$/)"});
    public static final GrammaticalRelation ARGUMENT = new GrammaticalRelation(GrammaticalRelation.Language.English, "arg", "argument", ArgumentGRAnnotation.class, GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation SUBJECT = new GrammaticalRelation(GrammaticalRelation.Language.English, "subj", "subject", SubjectGRAnnotation.class, ARGUMENT);
    public static final GrammaticalRelation NOMINAL_SUBJECT = new GrammaticalRelation(GrammaticalRelation.Language.English, "nsubj", "nominal subject", NominalSubjectGRAnnotation.class, SUBJECT, "S|SQ|SBARQ|SINV|SBAR|PRN", tregexCompiler, new String[]{"S < ((NP|WHNP=target !< EX !<# (/^NN/ < (/^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/))) $++ VP)", "S < ( NP=target <# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/) !$++ NP $++VP)", "SQ|PRN < (NP=target !< EX $++ VP)", "SQ < (NP=target !< EX $- (/^(?:VB|AUX)/ < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/) !$++ VP)", "SQ < (NP=target !< EX $- /^(?:VB|AUX)/ !$++ VP) !$-- NP|WHNP", "SQ < ((NP=target !< EX) $- (RB $- /^(?:VB|AUX)/) ![$++ VP])", "SBARQ < WHNP=target < (SQ < (VP !$-- NP))", "SBARQ < WHNP=target < (SQ < ((/^(?:VB)/ !< /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/) !$-- NP !$++ VP))", "SBARQ < (SQ=target < (/^(?:VB|AUX)/ < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/) !< VP)", "SINV < (NP|WHNP=target [ $- VP|VBZ|VBD|VBP|VB|MD|AUX | $- (@RB|ADVP $- VP|VBZ|VBD|VBP|VB|MD|AUX) | !$- __ !$ @NP] )", "S < (NP=target $+ NP|ADJP) > VP", "SBAR < WHNP=target [ < (S < (VP !$-- NP) !< SBAR) | < (VP !$-- NP) !< S ]", "SBAR !< WHNP < (S !< (NP $++ VP)) > (VP > (S $- WHNP=target))", "SQ < ((NP < EX) $++ NP=target)", "S < (NP < EX) <+(VP) (VP < NP=target)", "SBARQ < (/^(?:VB|AUX)/ < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/) < (WHNP < WP) < NP=target", "SBARQ < (WHNP=target $++ ((/^(?:VB|AUX)/ < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/) $++ ADJP=adj !$++ (NP $++ =adj)))", "SBARQ <1 WHNP=target < (SQ < (/^(?:VB|AUX)/ < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/) [< (NP < EX) | < PP])"});
    public static final GrammaticalRelation NOMINAL_PASSIVE_SUBJECT = new GrammaticalRelation(GrammaticalRelation.Language.English, "nsubjpass", "nominal passive subject", NominalPassiveSubjectGRAnnotation.class, NOMINAL_SUBJECT, "S|SQ", tregexCompiler, new String[]{"S|SQ < (WHNP|NP=target !< EX) < (VP < (/^(?:VB|AUX)/ < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|become|becomes|became|becoming|get|got|getting|gets|gotten|remains|remained|remain)$/)  < (VP < VBN|VBD))"});
    public static final GrammaticalRelation CLAUSAL_SUBJECT = new GrammaticalRelation(GrammaticalRelation.Language.English, "csubj", "clausal subject", ClausalSubjectGRAnnotation.class, SUBJECT, "S", tregexCompiler, new String[]{"S < (SBAR|S=target !$+ /^,$/ $++ (VP !$-- NP))"});
    public static final GrammaticalRelation CLAUSAL_PASSIVE_SUBJECT = new GrammaticalRelation(GrammaticalRelation.Language.English, "csubjpass", "clausal subject", ClausalPassiveSubjectGRAnnotation.class, CLAUSAL_SUBJECT, "S", tregexCompiler, new String[]{"S < (SBAR|S=target !$+ /^,$/ $++ (VP < (VP < VBN|VBD) < (/^(?:VB|AUXG?)/ < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|become|becomes|became|becoming|get|got|getting|gets|gotten|remains|remained|remain)$/) !$-- NP))", "S < (SBAR|S=target !$+ /^,$/ $++ (VP <+(VP) (VP < VBN|VBD > (VP < (/^(?:VB|AUX)/ < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|become|becomes|became|becoming|get|got|getting|gets|gotten|remains|remained|remain)$/))) !$-- NP))"});
    public static final GrammaticalRelation COMPLEMENT = new GrammaticalRelation(GrammaticalRelation.Language.English, "comp", "complement", ComplementGRAnnotation.class, ARGUMENT);
    public static final GrammaticalRelation OBJECT = new GrammaticalRelation(GrammaticalRelation.Language.English, "obj", "object", ObjectGRAnnotation.class, COMPLEMENT);
    public static final GrammaticalRelation DIRECT_OBJECT = new GrammaticalRelation(GrammaticalRelation.Language.English, "dobj", "direct object", DirectObjectGRAnnotation.class, OBJECT, "VP|SQ|SBARQ?", tregexCompiler, new String[]{"VP !< (/^(?:VB|AUX)/ < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/) < (NP|WHNP=target [ [ !<# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/) !$+ NP ] | $+ NP-TMP | $+ (NP <# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/)) ] )  <# (__ !$++ (NP $++ (/^[:]$/ $++ =target))) ", "SQ < (/^(?:VB)/=verb !< /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/) $-- WHNP !< VP !< (/^(?:VB)/ ! == =verb) < (NP|WHNP=target [ [ !<# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/) !$+ NP ] | $+ NP-TMP | $+ (NP <# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/)) ] )", "SBARQ < (WHNP=target !< WRB !<# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/)) <+(SQ|SINV|S|VP) (VP !< NP|TO !< (S < (VP < TO)) !< (/^(?:VB|AUX)/ < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/ $++ (VP < VBN|VBD)) !< (PP <: IN|TO) $-- (NP !< /^-NONE-$/))", "SBAR < (WHNP=target !< WRB) < (S < NP < (VP !< SBAR !<+(VP) (PP <- IN|TO) !< (S < (VP < TO))))", "SBAR !< (WHPP|WHNP|WHADVP) < (S < (@NP $++ (VP !< (/^(?:VB|AUX)/ < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/ !$+ VP)  !<+(VP) (/^(?:VB|AUX)/ < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/ $+ (VP < VBN|VBD)) !<+(VP) NP !< SBAR !<+(VP) (PP <- IN|TO)))) !$-- CC $-- NP > NP=target", "SBARQ < (WHNP=target $++ ((/^(?:VB|AUX)/ < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/) $++ (ADJP=adj !< (PP !< NP)) $++ (NP $++ =adj)))"});
    public static final GrammaticalRelation INDIRECT_OBJECT = new GrammaticalRelation(GrammaticalRelation.Language.English, "iobj", "indirect object", IndirectObjectGRAnnotation.class, OBJECT, "VP", tregexCompiler, new String[]{"VP < (NP=target !< /\\$/ !<# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/) $+ (NP !<# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/)))", "VP < (NP=target < (NP !< /\\$/ $++ (NP !< (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter|lot)$/)) !$ CC|CONJP !$ /^,$/ !$++ /^:$/))"});
    public static final GrammaticalRelation PREPOSITIONAL_OBJECT = new GrammaticalRelation(GrammaticalRelation.Language.English, "pobj", "prepositional object", PrepositionalObjectGRAnnotation.class, OBJECT, "SBARQ|PP(?:-TMP)?|WHPP|PRT|ADVP|WHADVP|XS", tregexCompiler, new String[]{"/^(?:PP(?:-TMP)?|(?:WH)?(?:PP|ADVP))$/ < (IN|VBG|TO|FW|RB|RBR $++ (/^(?:WH)?(?:NP|ADJP)(?:-TMP|-ADV)?$/=target !$- @NP))", "/^PP(?:-TMP)?$/ < (/^(?:IN|VBG|TO)$/ $+ (ADVP=target [ < (RB < /^(?i:here|there)$/) | < (ADVP < /^NP(?:-TMP)?$/) ] ))", "PRT >- (VP !< (S < (VP < TO)) >+(SQ|SINV|S|VP) (SBARQ <, (WHNP=target !< WRB)) $-- (NP !< /^-NONE-$/))", "(PP <: IN|TO) >- (VP !< (S < (VP < TO)) >+(SQ|SINV|S|VP) (SBARQ <, (WHNP=target !< WRB)) $-- (NP !< /^-NONE-$/))", "(PP <: IN|TO) $- (NP $-- (VBZ|VBD) !$++ VP) >+(SQ) (SBARQ <, (WHNP=target !< WRB)) $-- (NP !< /^-NONE-$/)", "(PP <- IN|TO) >+(@VP|S|SINV|SBAR) (SBAR !< (WHPP|WHNP) < (S < (NP $+ (VP !<(/^(?:VB|AUX)/ < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/ !$+ VP) !<+(VP) NP !< SBAR ))) $-- NP > NP=target)", "XS|ADVP < (IN < /^(?i:at)$/) < JJS|DT=target", "@WHPP|PP < (@WHPP|PP $++ (CC|CONJP $++ (@WHPP|PP $+ (NP=target !$+ __))))", "SBARQ < (WHNP=target $++ ((/^(?:VB|AUX)/ < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/) $++ (ADJP=adj < (PP !< NP)) $++ (NP $++ =adj)))"});
    public static final GrammaticalRelation PREPOSITIONAL_COMPLEMENT = new GrammaticalRelation(GrammaticalRelation.Language.English, "pcomp", "prepositional complement", PrepositionalComplementGRAnnotation.class, COMPLEMENT, "(?:WH)?PP(?:-TMP)?", tregexCompiler, new String[]{"@PP|WHPP < (IN|VBG|VBN|TO $+ @SBAR|S|PP|ADVP=target)", "@PP|WHPP < (RB $+ @SBAR|S=target)", "@PP|WHPP !< IN|TO < (SBAR=target <, (IN $+ S))"});
    public static final GrammaticalRelation CLAUSAL_COMPLEMENT = new GrammaticalRelation(GrammaticalRelation.Language.English, "ccomp", "clausal complement", ClausalComplementGRAnnotation.class, COMPLEMENT, "VP|SINV|S|ADJP|ADVP|NP(?:-.*)?", tregexCompiler, new String[]{"VP < (S=target < (VP !<, TO|VBG|VBN) !$-- NP)", "VP < (SBAR=target < (S <+(S) VP) <, (IN|DT < /^(?i:that|whether)$/))", "VP < (SBAR=target < (SBAR < (S <+(S) VP) <, (IN|DT < /^(?i:that|whether)$/)) < CC|CONJP)", "VP < (SBAR=target < (S < VP) !$-- NP !<, (IN|WHADVP) !<2 (IN|WHADVP $- ADVP|RB))", "VP < (SBAR=target < (S < VP) !$-- NP <, (WHADVP < (WRB < /^(?i:how)$/)))", "VP < @SBARQ=target", "VP < (/^VB/ < /^(?i:have|had|has|having|'ve|ve|v|'d|d|hvae|hav|as)$/) < (S=target < @NP < VP)", "S|SINV < (S|SBARQ=target $+ /^(,|\\.|'')$/ !$- /^(?:CC|CONJP|:)$/ !$- (/^(?:,)$/ $- CC|CONJP) !< (VP < TO|VBG|VBN))", "ADVP < (SBAR=target < (IN < /^(?i:as|that)/) < (S < (VP !< TO)))", "ADJP < (SBAR=target !< (IN < as) < S)", "S <, (SBAR=target <, (IN < /^(?i:that|whether)$/) !$+ VP)", "@NP < JJ|NN|NNS < (SBAR=target [ !<(S < (VP < TO )) | !$-- NP|NN|NNP|NNS ] )"});
    public static final GrammaticalRelation XCLAUSAL_COMPLEMENT = new GrammaticalRelation(GrammaticalRelation.Language.English, "xcomp", "xclausal complement", XClausalComplementGRAnnotation.class, COMPLEMENT, "VP|ADJP", tregexCompiler, new String[]{"VP < (S=target !$- (NN < order) < (VP < TO))", "ADJP < (S=target <, (VP <, TO))", "VP < (S=target !$- (NN < order) < (NP $+ NP|ADJP))", "VP < (/^(?:VB|AUX)/ $+ (VP=target < VB < NP))", "VP < (SBAR=target < (S !$- (NN < order) < (VP < TO))) !> (VP < (VB|AUX < be)) ", "VP < (S=target !$- (NN < order) <: NP) > VP", "(VP < (S=target < (VP < VBG ) !< NP !$- (/^,$/ [$- @NP|VP | $- (@PP $-- @NP ) |$- (@ADVP $-- @NP)]) !$-- /^:$/ !$-- VBG))", "(VP $-- (/^(?:VB|AUX)/ < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/) < (/^VB/ < /^(?i:seem|seems|seemed|seeming|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/) < NP=target)", "VP=vp < NP=target <(/^(?:VB|AUX)/ < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/ >># =vp) !$ (NP < EX)"});
    public static final GrammaticalRelation RELATIVE = new GrammaticalRelation(GrammaticalRelation.Language.English, "rel", "relative", RelativeGRAnnotation.class, COMPLEMENT, "SBAR", tregexCompiler, new String[]{"SBAR < (WHNP=target !< WRB) < (S < NP < (VP [ < SBAR | <+(VP) (PP <- IN|TO) | < (S < (VP < TO)) ] ))"});
    public static final GrammaticalRelation REFERENT = new GrammaticalRelation(GrammaticalRelation.Language.English, "ref", "referent", ReferentGRAnnotation.class, GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation EXPLETIVE = new GrammaticalRelation(GrammaticalRelation.Language.English, "expl", "expletive", ExpletiveGRAnnotation.class, GrammaticalRelation.DEPENDENT, "S|SQ|SINV", tregexCompiler, new String[]{"S|SQ|SINV < (NP=target <+(NP) EX)"});
    public static final GrammaticalRelation ADJECTIVAL_COMPLEMENT = new GrammaticalRelation(GrammaticalRelation.Language.English, "acomp", "adjectival complement", AdjectivalComplementGRAnnotation.class, COMPLEMENT, "VP", tregexCompiler, new String[]{"VP [ < ADJP=target |  < (/^VB/ $+ (@S=target < (@ADJP < /^JJ/ ! $-- @NP|S))) ]"});
    public static final GrammaticalRelation MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "mod", "modifier", ModifierGRAnnotation.class, GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation ADV_CLAUSE_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "advcl", "adverbial clause modifier", AdvClauseModifierGRAnnotation.class, MODIFIER, "VP|S|SQ|SINV|SBARQ", tregexCompiler, new String[]{"VP < (@SBAR=target [ < (IN !< /^(?i:that|whether)$/) | <: (SINV <1 /^(?:VB|MD|AUX)/) | < (RB|IN < so|now) < (IN < that) | <1 (ADVP < (RB < now)) <2 (IN < that) ] )", "S|SQ|SINV < (SBAR|SBAR-TMP=target <, (IN !< /^(?i:that|whether)$/ !$+ (NN < order)) !$-- /^(?!CC|CONJP|``|,|INTJ|PP(-.*)?).*$/ !$+ VP)", "S|SQ|SINV < (SBAR|SBAR-TMP=target <2 (IN !< /^(?i:that|whether)$/ !$+ (NN < order)) !$-- /^(?!CC|CONJP|``|,|INTJ|PP(-.*)?$).*$/)", "S|SQ|SINV < (SBAR|SBAR-TMP=target <, (IN !< /^(?i:that|whether)$/ !$+ (NN < order)) !$+ @VP $+ /^,$/ $++ @NP)", "SBARQ < (SBAR|SBAR-TMP|SBAR-ADV=target <, (IN !< /^(?i:that|whether)$/ !$+ (NN < order)) $+ /^,$/ $++ @SQ|S|SBARQ)", "S|SQ|VP < (SBAR|SBAR-TMP=target < (WHADVP|WHNP < (WRB !< /^(?i:how)$/) !$-- /^(?!RB|ADVP).*$/) !< (S < (VP < TO)) !$-- /^:$/)", "@S < (@SBAR=target $++ @NP $++ @VP)", "@S < (@S=target < (VP < TO) $+ (/^,$/ $++ @NP))"});
    public static final GrammaticalRelation RELATIVE_CLAUSE_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "rcmod", "relative clause modifier", RelativeClauseModifierGRAnnotation.class, MODIFIER, "(?:WH)?(?:NP|NML|ADVP)(?:-.*)?", tregexCompiler, new String[]{"@NP|WHNP|NML $++ (SBAR=target <+(SBAR) WHPP|WHNP) !$-- @NP|WHNP|NML > @NP|WHNP", "@NP|WHNP|NML $++ (SBAR=target <: (S !<, (VP <, TO))) !$-- @NP|WHNP|NLP > @NP|WHNP", "NP|NML $++ (SBAR=target < (WHADVP < (WRB </^(?i:where|why|when)/))) !$-- NP|NML > @NP", "@NP|WHNP <# NP|WHNP|NML|DT|S < RRC=target", "@ADVP < (@ADVP < (RB < /where$/)) < @SBAR=target"});
    public static final GrammaticalRelation MARKER = new GrammaticalRelation(GrammaticalRelation.Language.English, "mark", "marker", MarkerGRAnnotation.class, MODIFIER, "SBAR(?:-TMP)?", tregexCompiler, new String[]{"SBAR|SBAR-TMP < (IN|DT=target $++ S|FRAG)", "SBAR < (IN|DT=target < that|whether) [ $-- /^(?:VB|AUX)/ | $- NP|NN|NNS | > ADJP|PP | > (@NP|UCP|SBAR < CC|CONJP $-- /^(?:VB|AUX)/) ]"});
    public static final GrammaticalRelation ADJECTIVAL_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "amod", "adjectival modifier", AdjectivalModifierGRAnnotation.class, MODIFIER, "NP(?:-TMP|-ADV)?|NX|NML|NAC|WHNP|ADJP", tregexCompiler, new String[]{"/^(?:NP(?:-TMP|-ADV)?|NX|NML|NAC|WHNP)$/ < (ADJP|WHADJP|JJ|JJR|JJS|JJP|VBN|VBG|VBD|IN=target !< (QP !< /^[$]$/) !$- CC)", "ADJP !< CC|CONJP < (JJ|NNP $ JJ|NNP=target)", "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV < (NP=target <: CD $- /^,$/ $-- /^(?:WH)?NP/ !$ CC|CONJP)"});
    public static final GrammaticalRelation NUMERIC_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "num", "numeric modifier", NumericModifierGRAnnotation.class, MODIFIER, "(?:WH)?NP(?:-TMP|-ADV)?|NML|NX|ADJP|WHADJP|QP", tregexCompiler, new String[]{"/^(?:WH)?(?:NP|NX|NML)(?:-TMP|-ADV)?$/ < (CD|QP=target !$- CC)", "/^(?:WH)?(?:NP|NX|NML)(?:-TMP|-ADV)?$/ < (ADJP=target <: (QP !< /^[$]$/))", "/^(?:WH)?(?:NP|NX|NML)(?:-TMP|-ADV)?|(?:WH)?ADJP$/ < (QP < QP=target < /^[$]$/)", "QP < QP=target < /^[$]$/"});
    public static final GrammaticalRelation NUMBER_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "number", "compound number modifier", NumberModifierGRAnnotation.class, MODIFIER, "QP|ADJP", tregexCompiler, new String[]{"QP|ADJP < (/^(?:CD|$|#)$/=target !$- CC)"});
    public static final GrammaticalRelation QUANTIFIER_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "quantmod", "quantifier modifier", QuantifierModifierGRAnnotation.class, MODIFIER, "QP", tregexCompiler, new String[]{"QP < IN|RB|RBR|RBS|PDT|DT|JJ|JJR|JJS|XS=target"});
    public static final GrammaticalRelation NOUN_COMPOUND_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "nn", "nn modifier", NounCompoundModifierGRAnnotation.class, MODIFIER, "(?:WH)?(?:NP|NX|NAC|NML|ADVP|ADJP)(?:-TMP|-ADV)?", tregexCompiler, new String[]{"/^(?:WH)?(?:NP|NX|NAC|NML)(?:-TMP|-ADV)?$/ < (NP|NML|NN|NNS|NNP|NNPS|FW|AFX=target $++ NN|NNS|NNP|NNPS|FW|CD !<<- POS !<<- (VBZ < /^'s$/) !$- /^,$/ )", "/^(?:WH)?(?:NP|NX|NAC|NML)(?:-TMP|-ADV)?$/ < JJ|JJR|JJS=sister < (NP|NML|NN|NNS|NNP|NNPS|FW=target !<<- POS !<<- (VBZ < /^'s$/) $+ =sister) <# NN|NNS|NNP|NNPS !<<- POS !<<- (VBZ < /^'s$/) ", "ADJP|ADVP < (FW [ $- FW=target | $- (IN=target < in|In) ] )"});
    public static final GrammaticalRelation APPOSITIONAL_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "appos", "appositional modifier", AppositionalModifierGRAnnotation.class, MODIFIER, "(?:WH)?NP(?:-TMP|-ADV)?", tregexCompiler, new String[]{"WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV < (NP=target !<: CD $- /^,$/ $-- /^(?:WH)?NP/ !$ CC|CONJP)", "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV < (PRN=target < (NP < /^(?:NN|CD)/ $-- /^-LRB-$/ $+ /^-RRB-$/))", "@WHNP|NP < (NP=target !<: CD <, /^-LRB-$/ <` /^-RRB-$/ $-- /^(?:WH)?NP/ !$ CC|CONJP)", "NP|NP-TMP|NP-ADV < (NNP $+ (/^,$/ $+ NNP=target)) !< CC|CONJP", "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV < (PRN=target <, /^-LRB-$/ <- /^-RRB-$/ !<< /^(?:POS|(?:WP|PRP)\\$|[,$#]|CC|RB|CD)$/ <+(NP) (NNP|NN < /^(?:[A-Z]\\.?){2,}/) )", "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV < (NP=target <: NNP $- (/^(?:WH)?NP/ !< POS) !$ CC|CONJP)"});
    public static final GrammaticalRelation DISCOURSE_ELEMENT = new GrammaticalRelation(GrammaticalRelation.Language.English, "discourse", "discourse element", DiscourseElementGRAnnotation.class, MODIFIER, ".*", tregexCompiler, new String[]{"__ < (NFP=target < /^(?:[<>]?[:;=8][\\-o\\*']?(?:-RRB-|-LRB-|[DPdpO\\/\\\\\\:}{@\\|\\[\\]])|(?:-RRB-|-LRB-|[DPdpO\\/\\\\\\:}{@\\|\\[\\]])[\\-o\\*']?[:;=8][<>]?)$/)", "__ < (NFP=target < /^(?:-LRB-)?[\\-\\^x=~<>'][_.]?[\\-\\^x=~<>'](?:-RRB-)?$/)", "__ [ < INTJ=target | < (PRN=target <1 /^(?:,|-LRB-)$/ <2 INTJ [ !<3 __ | <3 /^(?:,|-RRB-)$/ ] ) ]"});
    public static final GrammaticalRelation PARTICIPIAL_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "partmod", "participial modifier", ParticipialModifierGRAnnotation.class, MODIFIER, "(?:WH)?NP(?:-TMP|-ADV)?|NML|NX|VP|S|SINV", tregexCompiler, new String[]{"WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV|NML|NX < (VP=target < VBG|VBN|VBD $-- @NP|NML|NX)", "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV|NML|NX < (/^,$/ $+ (VP=target [ <1 VBG|VBN | <2 (VBG|VBN $-- ADVP) ]))", "S|SINV < (S=target < (VP [ <1 VBG|VBN | <2 (VBG|VBN $-- ADVP) ]) [ $- (/^,$/ [ $- @NP | $- (@PP $ @NP) ] ) | $+ (/^,$/ $+ @NP) ] )", "(VP < (@S=target < (VP [ <1 VBG|VBN | <2 (VBG|VBN $-- ADVP) ]) $- (/^,$/ [$- @NP|VP | $- (@PP $-- @NP ) |$- (@ADVP $-- @NP)])))", "(VP < (S=target < (VP < VBG) $-- VBG=ing !$-- (/^[:]$/ $-- =ing)))"});
    public static final GrammaticalRelation INFINITIVAL_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "infmod", "infinitival modifier", InfinitivalModifierGRAnnotation.class, MODIFIER, "SBARQ|NP(?:-TMP|-ADV)?", tregexCompiler, new String[]{"/^NP(?:-[A-Z]+)?$/ < (S=target < (VP < TO) $-- NP|NN|NNP|NNS)", "/^NP(?:-[A-Z]+)?$/ < (SBAR=target < (S < (VP < TO)) $-- NP|NN|NNP|NNS)", "SBARQ < WHNP < (S=target < (VP <1 TO))"});
    private static final String NOT_PAT = "/^(?i:n[o']?t|never)$/";
    public static final GrammaticalRelation ADVERBIAL_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "advmod", "adverbial modifier", AdverbialModifierGRAnnotation.class, MODIFIER, "VP|ADJP|WHADJP|ADVP|WHADVP|S|SBAR|SINV|SQ|SBARQ|XS|(?:WH)?(?:PP|NP)(?:-TMP|-ADV)?|RRC|CONJP|JJP", tregexCompiler, new String[]{"/^(?:VP|ADJP|JJP|WHADJP|SQ?|SBARQ?|SINV|XS|RRC|(?:WH)?NP(?:-TMP|-ADV)?)$/ < (RB|RBR|RBS|WRB|ADVP|WHADVP=target !< /^(?i:n[o']?t|never)$/)", "ADVP|WHADVP < (RB|RBR|RBS|WRB|ADVP|WHADVP|JJ=target !< /^(?i:n[o']?t|never)$/) !< CC !< CONJP", "SBAR < (WHNP=target < WRB)", "SBARQ <, WHADVP=target", "XS < JJ=target", "/(?:WH)?PP(?:-TMP|-ADV)?$/ <# (__ $-- (RB|RBR|RBS|WRB|ADVP|WHADVP=target !< /^(?i:n[o']?t|never)$/))", "/(?:WH)?PP(?:-TMP|-ADV)?$/ < @NP|WHNP < (RB|RBR|RBS|WRB|ADVP|WHADVP=target !< /^(?i:n[o']?t|never)$/)", "CONJP < (RB=target !< /^(?i:n[o']?t|never)$/)"});
    public static final GrammaticalRelation NEGATION_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "neg", "negation modifier", NegationModifierGRAnnotation.class, ADVERBIAL_MODIFIER, "VP|ADJP|S|SBAR|SINV|SQ|NP(?:-TMP|-ADV)?|FRAG|CONJP|PP", tregexCompiler, new String[]{"/^(?:VP|NP(?:-TMP|-ADV)?|ADJP|SQ|S|FRAG|CONJP|PP)$/< (RB=target < /^(?i:n[o']?t|never)$/)", "VP|ADJP|S|SBAR|SINV|FRAG < (ADVP=target <# (RB < /^(?i:n[o']?t|never)$/))", "VP > SQ $-- (RB=target < /^(?i:n[o']?t|never)$/)"});
    public static final GrammaticalRelation NP_ADVERBIAL_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "npadvmod", "noun phrase adverbial modifier", NpAdverbialModifierGRAnnotation.class, MODIFIER, "VP|(?:WH)?(?:NP|ADJP|ADVP|PP)(?:-TMP|-ADV)?", tregexCompiler, new String[]{"@ADVP|ADJP|WHADJP|WHADVP|PP|WHPP <# (JJ|JJR|IN|RB|RBR !< notwithstanding $- (@NP=target !< NNP|NNPS))", "@ADJP < (NN=target $++ /^JJ/) !< CC|CONJP", "@NP|WHNP < /^NP-ADV/=target", "@NP <1 (@NP <<# /^%$/) <2 (@NP=target <<# days|month|months) !<3 __", "@VP < /^NP-ADV/=target"});
    public static final GrammaticalRelation TEMPORAL_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "tmod", "temporal modifier", TemporalModifierGRAnnotation.class, NP_ADVERBIAL_MODIFIER, "VP|S|ADJP|PP|SBAR|SBARQ|NP|RRC", tregexCompiler, new String[]{"VP|ADJP|RRC < NP-TMP=target", "VP|ADJP|RRC < (NP=target <# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/) !$+ (/^JJ/ < old))", "@PP < (IN|TO|VBG|FW $++ (@NP $+ NP-TMP=target))", "@PP < (IN|TO|VBG|FW $++ (@NP $+ (NP=target <# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/))))", "S < (NP-TMP=target $++ VP [ $++ NP | $-- NP] )", "S < (NP=target <# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/) $++ (NP $++ VP))", "SBAR < (@WHADVP < (WRB < when)) < (S < (NP $+ (VP !< (/^(?:VB|AUX)/ < /^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase|seem|seems|seemed|seeming|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|resembling|become|becomes|became|becoming)$/ !$+ VP) ))) !$-- CC $-- NP > NP=target", "SBARQ < (@WHNP=target <# (/^NN/ < /^(?i:Mondays?|Tuesdays?|Wednesdays?|Thursdays?|Fridays?|Saturdays?|Sundays?|years?|months?|weeks?|days?|mornings?|evenings?|nights?|January|Jan\\.|February|Feb\\.|March|Mar\\.|April|Apr\\.|May|June|July|August|Aug\\.|September|Sept\\.|October|Oct\\.|November|Nov\\.|December|Dec\\.|today|yesterday|tomorrow|spring|summer|fall|autumn|winter)$/)) < (SQ < @NP)", "NP < NP-TMP=target"});
    public static final GrammaticalRelation MULTI_WORD_EXPRESSION = new GrammaticalRelation(GrammaticalRelation.Language.English, "mwe", "multi-word expression", MultiWordExpressionGRAnnotation.class, MODIFIER, "PP|XS|ADVP|CONJP", tregexCompiler, new String[]{"PP|XS < (IN|TO < as|of|at|to|in) < (JJ|IN|JJR|JJS|NN=target < such|because|Because|least|instead|due|Due|addition|to)", "ADVP < (RB|IN < well) < (IN|RB|JJS=target < as)", "ADVP < (DT < all) < (CC < but)", "CONJP < (RB < rather|well|instead) < (RB|IN=target < as|than|of)", "CONJP < (IN < in) < (NN|TO=target < addition|to)", "XS < JJR|JJS=target"});
    public static final GrammaticalRelation DETERMINER = new GrammaticalRelation(GrammaticalRelation.Language.English, "det", "determiner", DeterminerGRAnnotation.class, MODIFIER, "(?:WH)?NP(?:-TMP|-ADV)?|NAC|NML|NX|X|ADVP", tregexCompiler, new String[]{"/^(?:NP(?:-TMP|-ADV)?|NAC|NML|NX|X)$/ < (DT=target !< /^(?i:either|neither|both)$/ !$+ DT !$++ CC $++ /^(?:N[MNXP]|CD|JJ|FW|ADJP|QP|RB|PRP(?![$])|PRN)/=det !$++ (/^PRP[$]|POS/ $++ =det !$++ (/''/ $++ =det)))", "NP|NP-TMP|NP-ADV < (DT=target < /^(?i:either|neither|both)$/ !$+ DT !$++ CC $++ /^(?:NN|NX|NML)/ !$++ (NP < CC))", "NP|NP-TMP|NP-ADV < (DT=target !< /^(?i:either|neither|both)$/ $++ CC $++ /^(?:NN|NX|NML)/)", "NP|NP-TMP|NP-ADV < (DT=target $++ (/^JJ/ !$+ /^NN/) !$++CC !$+ DT)", "NP|NP-TMP|NP-ADV <<, PRP <- (NP|DT|RB=target <<- all|both|each)", "WHNP < (NP $-- (WHNP=target < WDT))", "@WHNP|ADVP < (/^(?:NP|NN|CD|RBS)/ $-- DT|WDT|WP=target)", "@NP < (/^(?:NP|NN|CD|RBS)/ $-- WDT|WP=target)"});
    public static final GrammaticalRelation PREDETERMINER = new GrammaticalRelation(GrammaticalRelation.Language.English, "predet", "predeterminer", PredeterminerGRAnnotation.class, MODIFIER, "(?:WH)?(?:NP|NX|NAC|NML)(?:-TMP|-ADV)?", tregexCompiler, new String[]{"/^(?:(?:WH)?NP(?:-TMP|-ADV)?|NX|NAC|NML)$/ < (PDT|DT=target $+ /^(?:DT|WP\\$|PRP\\$)$/ $++ /^N[NXM]/ !$++ CC)", "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV < (PDT|DT=target $+ DT $++ (/^JJ/ !$+ /^NN/)) !$++ CC", "WHNP|WHNP-TMP|WHNP-ADV|NP|NP-TMP|NP-ADV < PDT=target <- DT"});
    public static final GrammaticalRelation PRECONJUNCT = new GrammaticalRelation(GrammaticalRelation.Language.English, "preconj", "preconjunct", PreconjunctGRAnnotation.class, MODIFIER, "S|VP|ADJP|PP|ADVP|UCP(?:-TMP|-ADV)?|NX|NML|SBAR|NP(?:-TMP|-ADV)?", tregexCompiler, new String[]{"NP|NP-TMP|NP-ADV|NX|NML < (PDT|CC|DT=target < /^(?i:either|neither|both)$/ $++ CC)", "NP|NP-TMP|NP-ADV|NX|NML < (CONJP=target < (RB < /^(?i:not)$/) < (RB|JJ < /^(?i:only|merely|just)$/) $++ CC|CONJP)", "NP|NP-TMP|NP-ADV|NX|NML < (PDT|CC|DT=target < /^(?i:either|neither|both)$/ ) < (NP < CC)", "/^S|VP|ADJP|PP|ADVP|UCP(?:-TMP|-ADV)?|NX|NML|SBAR$/ < (PDT|DT|CC=target < /^(?i:either|neither|both)$/ $++ CC)", "/^S|VP|ADJP|PP|ADVP|UCP(?:-TMP|-ADV)?|NX|NML|SBAR$/ < (CONJP=target < (RB < /^(?i:not)$/) < (RB|JJ < /^(?i:only|merely|just)$/) $++ CC|CONJP)"});
    public static final GrammaticalRelation POSSESSION_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "poss", "possession modifier", PossessionModifierGRAnnotation.class, MODIFIER, "(?:WH)?(NP|ADJP|INTJ|PRN|NAC|NX|NML)(?:-.*)?", tregexCompiler, new String[]{"/^(?:WH)?(?:NP|INTJ|ADJP|PRN|NAC|NX|NML)(?:-.*)?$/ < /^(?:W|PR)P\\$$/=target", "/^(?:WH)?(?:NP|NML)(?:-.*)?$/ [ < (WHNP|WHNML|NP|NML=target [ < POS | < (VBZ < /^'s$/) ] ) !< (CC|CONJP $++ WHNP|WHNML|NP|NML) |  < (WHNP|WHNML|NP|NML=target < (CC|CONJP $++ WHNP|WHNML|NP|NML) < (WHNP|WHNML|NP|NML [ < POS | < (VBZ < /^'s$/) ] )) ]", "/^(?:WH)?(?:NP|NML)(?:-.*)?$/ < (/^NN/=target $+ (POS < /'/ $++ /^NN/))"});
    public static final GrammaticalRelation POSSESSIVE_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "possessive", "possessive modifier", PossessiveModifierGRAnnotation.class, MODIFIER, "(?:WH)?(?:NP|NML)(?:-TMP|-ADV)?", tregexCompiler, new String[]{"/^(?:WH)?(?:NP|NML)(?:-TMP|-ADV)?$/ < POS=target", "/^(?:WH)?(?:NP|NML)(?:-TMP|-ADV)?$/ < (VBZ=target < /^'s$/)"});
    public static final GrammaticalRelation PREPOSITIONAL_MODIFIER = new GrammaticalRelation(GrammaticalRelation.Language.English, "prep", "prepositional modifier", PrepositionalModifierGRAnnotation.class, MODIFIER, ".*", tregexCompiler, new String[]{"/^(?:(?:WH)?(?:NP|ADJP|ADVP|NX|NML)(?:-TMP|-ADV)?|VP|NAC|SQ|FRAG|PRN|X|RRC)$/ < (WHPP|WHPP-TMP|PP|PP-TMP=target !$- (@CC|CONJP $- __))", "/^(?:(?:WH)?(?:NP|ADJP|ADVP|NX|NML)(?:-TMP|-ADV)?|VP|NAC|SQ|FRAG|PRN|X|RRC)$/ < (S=target <: WHPP|WHPP-TMP|PP|PP-TMP)", "WHPP|WHPP-TMP|WHPP-ADV|PP|PP-TMP|PP-ADV < (WHPP|WHPP-TMP|WHPP-ADV|PP|PP-TMP|PP-ADV=target !$- IN|VBG|VBN|TO) !< @CC|CONJP", "S|SINV < (PP|PP-TMP=target !< SBAR) < VP|S", "SBAR|SBARQ < /^(?:WH)?PP/=target < S|SQ", "@NP < (@UCP|PRN=target <# @PP)"});
    public static final GrammaticalRelation PHRASAL_VERB_PARTICLE = new GrammaticalRelation(GrammaticalRelation.Language.English, "prt", "phrasal verb particle", PhrasalVerbParticleGRAnnotation.class, MODIFIER, "VP|ADJP", tregexCompiler, new String[]{"VP < PRT=target", "ADJP < /^VB/ < RP=target"});
    public static final GrammaticalRelation PARATAXIS = new GrammaticalRelation(GrammaticalRelation.Language.English, "parataxis", "parataxis", ParataxisGRAnnotation.class, GrammaticalRelation.DEPENDENT, "S|VP", tregexCompiler, new String[]{"VP < (PRN=target < S|SINV|SBAR)", "VP $ (PRN=target [ < S|SINV|SBAR | < VP < @NP ] )", "S|VP < (/^:$/ $+ /^S/=target) !<, (__ $++ CC|CONJP)", "@S < (@S $.. @S=target) !< @CC|CONJP", "@S|VP < (/^:$/ $-- /^V/ $+ @NP=target) !< @CONJP|CC"});
    public static final GrammaticalRelation GOES_WITH = new GrammaticalRelation(GrammaticalRelation.Language.English, "goeswith", "goes with", GoesWithGRAnnotation.class, MODIFIER, ".*", tregexCompiler, new String[]{"__ < GW=target"});
    public static final GrammaticalRelation SEMANTIC_DEPENDENT = new GrammaticalRelation(GrammaticalRelation.Language.English, "sdep", "semantic dependent", SemanticDependentGRAnnotation.class, GrammaticalRelation.DEPENDENT);
    public static final GrammaticalRelation CONTROLLING_SUBJECT = new GrammaticalRelation(GrammaticalRelation.Language.English, "xsubj", "controlling subject", ControllingSubjectGRAnnotation.class, SEMANTIC_DEPENDENT);
    public static final GrammaticalRelation AGENT = new GrammaticalRelation(GrammaticalRelation.Language.English, "agent", "agent", AgentGRAnnotation.class, GrammaticalRelation.DEPENDENT);
    private static final List<GrammaticalRelation> values = Generics.newArrayList(Arrays.asList(GrammaticalRelation.GOVERNOR, GrammaticalRelation.DEPENDENT, PREDICATE, AUX_MODIFIER, AUX_PASSIVE_MODIFIER, COPULA, CONJUNCT, COORDINATION, PUNCTUATION, ARGUMENT, SUBJECT, NOMINAL_SUBJECT, NOMINAL_PASSIVE_SUBJECT, CLAUSAL_SUBJECT, CLAUSAL_PASSIVE_SUBJECT, COMPLEMENT, OBJECT, DIRECT_OBJECT, INDIRECT_OBJECT, PREPOSITIONAL_OBJECT, PREPOSITIONAL_COMPLEMENT, CLAUSAL_COMPLEMENT, XCLAUSAL_COMPLEMENT, MARKER, RELATIVE, REFERENT, EXPLETIVE, ADJECTIVAL_COMPLEMENT, MODIFIER, ADV_CLAUSE_MODIFIER, TEMPORAL_MODIFIER, RELATIVE_CLAUSE_MODIFIER, NUMERIC_MODIFIER, ADJECTIVAL_MODIFIER, NOUN_COMPOUND_MODIFIER, APPOSITIONAL_MODIFIER, PARTICIPIAL_MODIFIER, INFINITIVAL_MODIFIER, ADVERBIAL_MODIFIER, NEGATION_MODIFIER, MULTI_WORD_EXPRESSION, DETERMINER, PREDETERMINER, PRECONJUNCT, POSSESSION_MODIFIER, POSSESSIVE_MODIFIER, PREPOSITIONAL_MODIFIER, PHRASAL_VERB_PARTICLE, SEMANTIC_DEPENDENT, CONTROLLING_SUBJECT, AGENT, NUMBER_MODIFIER, QUANTIFIER_MODIFIER, NP_ADVERBIAL_MODIFIER, PARATAXIS, DISCOURSE_ELEMENT, GOES_WITH));
    private static final List<GrammaticalRelation> unmodifiableValues = Collections.unmodifiableList(values);
    private static final List<GrammaticalRelation> synchronizedValues = Collections.synchronizedList(values);
    private static final List<GrammaticalRelation> unmodifiableSynchronizedValues = Collections.unmodifiableList(values);
    public static final ReadWriteLock valuesLock = new ReentrantReadWriteLock();
    public static final Map<String, GrammaticalRelation> shortNameToGRel = new ConcurrentHashMap<String, GrammaticalRelation>();
    private static final Map<String, GrammaticalRelation> conjs;
    private static final Map<String, GrammaticalRelation> preps;
    private static final Map<String, GrammaticalRelation> prepsC;

    private EnglishGrammaticalRelations() {
    }

    public static List<GrammaticalRelation> values() {
        return EnglishGrammaticalRelations.values(false);
    }

    public static List<GrammaticalRelation> values(boolean threadSafe) {
        return threadSafe ? unmodifiableSynchronizedValues : unmodifiableValues;
    }

    public static Lock valuesLock() {
        return valuesLock.readLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void threadSafeAddRelation(GrammaticalRelation relation) {
        valuesLock.writeLock().lock();
        try {
            synchronizedValues.add(relation);
            shortNameToGRel.put(relation.toString(), relation);
        }
        finally {
            valuesLock.writeLock().unlock();
        }
    }

    public static Collection<GrammaticalRelation> getConjs() {
        return conjs.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GrammaticalRelation getConj(String conjunctionString) {
        GrammaticalRelation result = conjs.get(conjunctionString);
        if (result == null) {
            Map<String, GrammaticalRelation> map = conjs;
            synchronized (map) {
                result = conjs.get(conjunctionString);
                if (result == null) {
                    result = new GrammaticalRelation(GrammaticalRelation.Language.English, "conj", "conj_collapsed", null, CONJUNCT, conjunctionString);
                    conjs.put(conjunctionString, result);
                    EnglishGrammaticalRelations.threadSafeAddRelation(result);
                }
            }
        }
        return result;
    }

    public static Collection<GrammaticalRelation> getPreps() {
        return preps.values();
    }

    public static Collection<GrammaticalRelation> getPrepsC() {
        return prepsC.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GrammaticalRelation getPrep(String prepositionString) {
        GrammaticalRelation result = preps.get(prepositionString);
        if (result == null) {
            Map<String, GrammaticalRelation> map = preps;
            synchronized (map) {
                result = preps.get(prepositionString);
                if (result == null) {
                    result = new GrammaticalRelation(GrammaticalRelation.Language.English, "prep", "prep_collapsed", null, PREPOSITIONAL_MODIFIER, prepositionString);
                    preps.put(prepositionString, result);
                    EnglishGrammaticalRelations.threadSafeAddRelation(result);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GrammaticalRelation getPrepC(String prepositionString) {
        GrammaticalRelation result = prepsC.get(prepositionString);
        if (result == null) {
            Map<String, GrammaticalRelation> map = prepsC;
            synchronized (map) {
                result = prepsC.get(prepositionString);
                if (result == null) {
                    result = new GrammaticalRelation(GrammaticalRelation.Language.English, "prepc", "prepc_collapsed", null, GrammaticalRelation.DEPENDENT, prepositionString);
                    prepsC.put(prepositionString, result);
                    EnglishGrammaticalRelations.threadSafeAddRelation(result);
                }
            }
        }
        return result;
    }

    public static GrammaticalRelation valueOf(String s) {
        return GrammaticalRelation.valueOf(s, values);
    }

    public static GrammaticalRelation valueOf(Object o) {
        if (o instanceof GrammaticalRelation) {
            return (GrammaticalRelation)o;
        }
        if (o instanceof Class) {
            try {
                return GrammaticalRelation.getRelation((Class)o);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (o instanceof String) {
            return EnglishGrammaticalRelations.valueOf((String)o);
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(GrammaticalRelation.DEPENDENT.toPrettyString());
    }

    static {
        for (GrammaticalRelation gr : EnglishGrammaticalRelations.values()) {
            shortNameToGRel.put(gr.toString().toLowerCase(), gr);
        }
        conjs = Generics.newConcurrentHashMap();
        preps = Generics.newConcurrentHashMap();
        prepsC = Generics.newConcurrentHashMap();
    }

    public static class AgentGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ControllingSubjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class SemanticDependentGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class GoesWithGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ParataxisGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PhrasalVerbParticleGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PrepositionalModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PossessiveModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PossessionModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PreconjunctGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PredeterminerGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class DeterminerGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class MultiWordExpressionGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class TemporalModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class NpAdverbialModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class NegationModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AdverbialModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class InfinitivalModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ParticipialModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class DiscourseElementGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AppositionalModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class NounCompoundModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class QuantifierModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class NumberModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class NumericModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AdjectivalModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class MarkerGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class RelativeClauseModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AdvClauseModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AdjectivalComplementGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ExpletiveGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ReferentGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class RelativeGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class XClausalComplementGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ClausalComplementGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PrepositionalComplementGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PrepositionalObjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class IndirectObjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class DirectObjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ObjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ComplementGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ClausalPassiveSubjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ClausalSubjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class NominalPassiveSubjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class NominalSubjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class SubjectGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ArgumentGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PunctuationGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class CoordinationGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class ConjunctGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class CopulaGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AuxPassiveGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class AuxModifierGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }

    public static class PredicateGRAnnotation
    extends GrammaticalRelation.GrammaticalRelationAnnotation {
    }
}

