# NetworksAndLangChange

Dynamical systems framework (cf Niyogi &amp; Berwick 1997, 2009) for modeling language change in populations of learners extended to represent arbitrary social network structures.

## Setup

Just run **setup.sh** or create a plots directory in the parent directory. Nothing to install. 

## Dependencies

Everything was implemented in Python 2.7. Numpy is the only external library required..

## Experiment Files

There is no user interface yet. Files of the form exp_*.py reproduce plots provided in the ACL paper  and serve as code examples

- **exp_singleg.py** Multi-clustered network structure yields S-curve change in populations of single-grammared speakers cf Yang 2009 cot-caught merger

- **exp_smallpops.py** Demonstrating the combined effect of small networks and single-grammar speakers on neutral (cf Kauhanen 2016) and advantaged change

## Model Files

These implement the model

- **applyT.py** Apply T learner transition matrix

- **calcE.py** Calculate P learner input matrix matrix

- **calcTfromextensions.py** Automatically create T matrix from grammar extensions

- **generateA.py** Generate A adjacency matrix

- **updateG.py** Update B grammar expression matrix
