/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.modification.treesegs;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import matetools.is2.data.Cluster;
import matetools.is2.data.DataFES;
import matetools.is2.data.F2SF;
import matetools.is2.data.Instances;
import matetools.is2.data.Long2IntInterface;
import matetools.is2.modification.morefeatures.MoreFeaturesInterface;
import matetools.is2.modification.treesegs.TreeSegmentsExtractor;
import matetools.is2.parser.Edges;

public final class TreeSegmentsParallelExtract
implements Callable<Object> {
    final DataFES d;
    final TreeSegmentsExtractor extractor;
    private Instances is;
    private int i;
    private F2SF para;
    private Cluster cluster;
    static ArrayList<DSet> sets = new ArrayList();

    public TreeSegmentsParallelExtract(TreeSegmentsExtractor e, Instances is, int i, DataFES d, F2SF para, Cluster cluster) {
        this.is = is;
        this.extractor = e;
        this.d = d;
        this.i = i;
        this.para = para;
        this.cluster = cluster;
    }

    @Override
    public Object call() {
        try {
            DSet set;
            F2SF f = this.para;
            short[] pos = this.is.pposs[this.i];
            int length = pos.length;
            long[] gvs = new long[50];
            long[] svs = new long[220];
            while ((set = this.get()) != null) {
                int lv;
                short label;
                int x1 = set.w1;
                int x2 = set.w2;
                int w1 = this.is.originalPosition[this.i][x1];
                int w2 = this.is.originalPosition[this.i][x2];
                f.clear();
                this.extractor.basic(pos, w1, w2, f);
                this.d.pl[x1][x2] = f.getScoreF();
                f.clear();
                this.extractor.basic(pos, w2, w1, f);
                this.d.pl[x2][x1] = f.getScoreF();
                short[] labels = Edges.get(pos[w1], pos[w2]);
                float[] lab = this.d.lab[x1][x2];
                Long2IntInterface li = this.extractor.li;
                int c = this.extractor.firstm(this.is, this.i, w1, w2, 0, this.cluster, svs);
                List<Long> moreFeats = MoreFeaturesInterface.moreFeatures(this.is, this.i, w1, w2, 0);
                int l = 0;
                while (l < lab.length) {
                    lab[l] = -100.0f;
                    ++l;
                }
                l = 0;
                while (l < labels.length) {
                    label = labels[l];
                    f.clear();
                    lv = this.extractor.d0.computeLabeValue(label, TreeSegmentsExtractor.s_type);
                    int k = 0;
                    while (k < c) {
                        if (svs[k] > 0L) {
                            f.add(li.l2i(svs[k] + (long)lv));
                        }
                        ++k;
                    }
                    for (long feat : moreFeats) {
                        f.add(li.l2i(feat + (long)lv));
                    }
                    lab[label] = f.getScoreF();
                    ++l;
                }
                labels = Edges.get(pos[w2], pos[w1]);
                lab = this.d.lab[x2][x1];
                l = 0;
                while (l < lab.length) {
                    lab[l] = -100.0f;
                    ++l;
                }
                l = 0;
                while (l < labels.length) {
                    label = labels[l];
                    f.clear();
                    lv = this.extractor.d0.computeLabeValue(label + TreeSegmentsExtractor.s_rel1, TreeSegmentsExtractor.s_type);
                    int k = 0;
                    while (k < c) {
                        if (svs[k] > 0L) {
                            f.add(li.l2i(svs[k] + (long)lv));
                        }
                        ++k;
                    }
                    for (long feat : moreFeats) {
                        f.add(li.l2i(feat + (long)lv));
                    }
                    lab[label] = f.getScoreF();
                    ++l;
                }
                int m = 0;
                while (m < this.is.heads[this.i].length) {
                    if (m >= x1) {
                        labels = Edges.get(pos[w1], pos[w2]);
                        float[] lab2 = new float[labels.length];
                        this.d.gra[x1][x2][m] = lab2;
                    }
                    if (m <= x2) {
                        labels = Edges.get(pos[w2], pos[w1]);
                        float[] lab2 = new float[labels.length];
                        this.d.gra[x2][x1][m] = lab2;
                    }
                    if (m >= x1 && m <= x2) {
                        labels = Edges.get(pos[w1], pos[w2]);
                        float[] lab2 = new float[labels.length];
                        this.d.sib[x1][x2][m] = lab2;
                    }
                    if (m >= x1 && m <= x2) {
                        labels = Edges.get(pos[w2], pos[w1]);
                        float[] lab2 = new float[labels.length];
                        this.d.sib[x2][x1][m] = lab2;
                    }
                    ++m;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DSet get() {
        ArrayList<DSet> arrayList = sets;
        synchronized (arrayList) {
            block4: {
                if (sets.size() != 0) break block4;
                return null;
            }
            return sets.remove(sets.size() - 1);
        }
    }

    public static void add(int w1, int w2) {
        DSet ds = new DSet();
        ds.w1 = w1;
        ds.w2 = w2;
        sets.add(ds);
    }

    public static class DSet {
        int w1;
        int w2;
    }
}

