/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.ListUtils;
import fig.basic.StrUtils;
import fig.basic.Utils;
import fig.servlet.Field;
import fig.servlet.FieldListMap;
import fig.servlet.Item;
import fig.servlet.MyException;
import fig.servlet.MyExceptions;
import fig.servlet.ValueProcessor;

public class FieldItem
extends Item {
    public FieldItem(Item parent, String name) {
        super(parent, name, null);
        this.metadataMap.put("numeric", "false");
    }

    @Override
    public FieldListMap getMetadataFields() {
        FieldListMap fields = new FieldListMap();
        fields.add((String)"displayName", (String)"What is actually displayed").mutable = true;
        fields.add((String)"gloss", (String)"Description of what the field is.").mutable = true;
        fields.add((String)"data", (String)"Specifies how to populate the field, separated by spaces; use $ for intrinsic fields.").mutable = true;
        fields.add((String)"numeric", (String)"Whether this is a numeric (for sorting)").mutable = true;
        fields.add((String)"mutable", (String)"Whether we can edit this").mutable = true;
        fields.add((String)"multiline", (String)"When editing, use multiple lines").mutable = true;
        fields.add((String)"hidden", (String)"Whether to hide the field").mutable = true;
        fields.add((String)"width", (String)"Width of the column").setMutable((boolean)true).numeric = true;
        fields.add((String)"rank", (String)"Determines order of columns").setMutable((boolean)true).numeric = true;
        fields.add((String)"process", (String)"How to process the value once we're done with it").mutable = true;
        return fields;
    }

    public Field createField() {
        if (this.metadataMap == null) {
            return null;
        }
        String displayName = (String)this.metadataMap.get("displayName");
        String gloss = (String)this.metadataMap.get("gloss");
        Object[] objs = ListUtils.toObjectArray(StrUtils.split((String)this.metadataMap.get("data")));
        Field field = FieldListMap.parseField(this.name, displayName, gloss, objs);
        field.numeric = Boolean.parseBoolean((String)this.metadataMap.get("numeric"));
        field.mutable = Boolean.parseBoolean((String)this.metadataMap.get("mutable"));
        field.multiline = Boolean.parseBoolean((String)this.metadataMap.get("multiline"));
        field.hidden = Boolean.parseBoolean((String)this.metadataMap.get("hidden"));
        field.width = Utils.parseIntEasy((String)this.metadataMap.get("width"), 0);
        field.rank = Utils.parseIntEasy((String)this.metadataMap.get("rank"), 1);
        field.processor = new ValueProcessor((String)this.metadataMap.get("process"));
        return field;
    }

    public void setFromField(Field field) {
        this.metadataMap.put("displayName", field.displayName);
        this.metadataMap.put("gloss", field.gloss);
        this.metadataMap.put("data", field.toString());
        if (field.numeric) {
            this.metadataMap.put("numeric", "true");
        }
        if (field.mutable) {
            this.metadataMap.put("mutable", "true");
        }
        if (field.multiline) {
            this.metadataMap.put("multiline", "true");
        }
        if (field.hidden) {
            this.metadataMap.put("hidden", "true");
        }
        if (field.width > 0) {
            this.metadataMap.put("width", "" + field.width);
        }
        this.metadataMap.put("rank", "" + field.rank);
        if (field.processor != null && !field.processor.isIdentity()) {
            this.metadataMap.put("process", field.processor.toString());
        }
    }

    @Override
    protected boolean isView() {
        return false;
    }

    @Override
    public Item newItem(String name) throws MyException {
        throw MyExceptions.unsupported;
    }
}

