/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.servlet.DomainItem;
import fig.servlet.ExecItem;
import fig.servlet.ExecViewDB;
import fig.servlet.Field;
import fig.servlet.FieldListMap;
import fig.servlet.FieldSpecItem;
import fig.servlet.Item;
import fig.servlet.MyException;
import fig.servlet.UpdateQueue;
import java.io.File;

public abstract class ExecView
extends Item {
    public ExecView(Item parent, String name, String sourcePath) {
        super(parent, name, sourcePath);
    }

    @Override
    protected FieldListMap getMetadataFields() {
        FieldListMap fields = new FieldListMap();
        fields.add(countField);
        Field f = fields.add("description", "One-line description");
        if (this.hasMutableMetadata()) {
            f.mutable = true;
        }
        f = fields.add("note", "Random comments");
        if (this.hasMutableMetadata()) {
            f.mutable = true;
            f.multiline = true;
        }
        return fields;
    }

    @Override
    protected FieldListMap getItemsFields() {
        Item fieldSpecItem;
        DomainItem item = (DomainItem)this.findAncestorByClass(DomainItem.class);
        if (item != null && (fieldSpecItem = item.fieldSpecView.getItemEasy("default")) != null) {
            return ((FieldSpecItem)fieldSpecItem).createFieldListMap();
        }
        return ExecItem.createDefaultFields();
    }

    protected abstract boolean hasMutableMetadata();

    public UpdateQueue getPrioritizedItems(UpdateQueue.Priority priority) {
        UpdateQueue queue = new UpdateQueue();
        for (Item item : this.items.values()) {
            if (item instanceof ExecItem) {
                ExecItem execItem = (ExecItem)item;
                if (execItem.immutable) continue;
                queue.enqueue(item, !execItem.hasUpdated || execItem.isRunning() ? priority : priority.next());
                continue;
            }
            queue.enqueue(item, priority);
        }
        return queue;
    }

    @Override
    protected String tableType() {
        return "ExecView";
    }

    @Override
    protected boolean isView() {
        return true;
    }

    @Override
    protected Item newItem(String name) throws MyException {
        return new ExecItem(this, name, new File(this.sourcePath, name).toString());
    }

    protected ExecViewDB getExecViewDB() {
        return (ExecViewDB)this.findAncestorByClass(ExecViewDB.class);
    }

    protected ExecView getAllExecView() {
        return this.getExecViewDB().allExecView;
    }
}

