/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import fig.basic.AbstractT2Map;
import fig.basic.AbstractTMap;
import fig.basic.LogInfo;
import fig.basic.T2DoubleMap;
import fig.basic.TVMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class T2VMap<S, T, V>
extends AbstractT2Map
implements Iterable<Map.Entry<S, TVMap<T, V>>>,
Serializable {
    protected static final long serialVersionUID = 42L;
    private Map<S, TVMap<T, V>> maps = new HashMap<S, TVMap<T, V>>();
    private S lastKey;
    private TVMap<T, V> lastMap;
    protected AbstractTMap.Functionality<V> valueFunc;

    public T2VMap() {
        this.keyFunc = AbstractTMap.defaultFunctionality;
        this.valueFunc = AbstractTMap.defaultFunctionality;
    }

    public T2VMap(AbstractTMap.Functionality<T> keyFunc, AbstractTMap.Functionality<V> valueFunc) {
        this.keyFunc = keyFunc;
        this.valueFunc = valueFunc;
    }

    public void initKeys(AbstractT2Map map) {
        this.locked = map.locked;
        if (map instanceof T2DoubleMap) {
            for (Map.Entry e : (T2DoubleMap)map) {
                this.put(e.getKey(), new TVMap(e.getValue(), this.valueFunc));
            }
        } else if (map instanceof T2VMap) {
            for (Map.Entry<S, TVMap<T, V>> e : (T2VMap)map) {
                this.put(e.getKey(), new TVMap(e.getValue(), this.valueFunc));
            }
        } else {
            throw new RuntimeException("");
        }
    }

    public boolean containsKey(S key1, T key2) {
        TVMap<T, V> map = this.getMap(key1, false);
        return map != null && map.containsKey(key2);
    }

    public V get(S key1, T key2, V defaultValue) {
        TVMap<T, V> map = this.getMap(key1, false);
        return map == null ? defaultValue : map.get(key2, defaultValue);
    }

    public V getWithErrorMsg(S key1, T key2, V defaultValue) {
        TVMap<T, V> map = this.getMap(key1, false);
        if (map == null) {
            LogInfo.errors("(%s, %s) not in map, using %f", key1, key2, defaultValue);
        }
        return map == null ? defaultValue : map.get(key2, defaultValue);
    }

    public V getSure(S key1, T key2) {
        TVMap<T, V> map = this.getMap(key1, false);
        if (map == null) {
            throw new RuntimeException("Missing key: " + key1);
        }
        return map.getSure(key2);
    }

    public void put(S key1, TVMap<T, V> map) {
        if (this.locked) {
            throw new RuntimeException("Cannot make new entry for " + key1 + ", because map is locked");
        }
        this.maps.put(key1, map);
    }

    public void put(S key1, T key2, V value) {
        TVMap<T, V> map = this.getMap(key1, true);
        map.put(key2, value);
    }

    @Override
    public int size() {
        return this.maps.size();
    }

    public int totalSize() {
        int n = 0;
        for (TVMap<T, V> map : this.maps.values()) {
            n += map.size();
        }
        return n;
    }

    public void gut() {
        for (TVMap<T, V> map : this.maps.values()) {
            map.gut();
        }
    }

    @Override
    public Iterator<Map.Entry<S, TVMap<T, V>>> iterator() {
        return this.maps.entrySet().iterator();
    }

    public Set<Map.Entry<S, TVMap<T, V>>> entrySet() {
        return this.maps.entrySet();
    }

    public Set<S> keySet() {
        return this.maps.keySet();
    }

    public Collection<TVMap<T, V>> values() {
        return this.maps.values();
    }

    public T2VMap<S, T, V> copy() {
        return this.copy(this.newMap());
    }

    public T2VMap<S, T, V> copy(T2VMap<S, T, V> newMap) {
        newMap.locked = this.locked;
        for (Map.Entry<S, TVMap<T, V>> e : this.maps.entrySet()) {
            newMap.maps.put(e.getKey(), e.getValue().copy());
        }
        return newMap;
    }

    public T2VMap<S, T, V> restrict(Set<S> set1, Set<T> set2) {
        return this.restrict(this.newMap(), set1, set2);
    }

    public T2VMap<S, T, V> restrict(T2VMap<S, T, V> newMap, Set<S> set1, Set<T> set2) {
        newMap.locked = this.locked;
        for (Map.Entry<S, TVMap<T, V>> e : this.maps.entrySet()) {
            if (!set1.contains(e.getKey())) continue;
            newMap.maps.put(e.getKey(), e.getValue().restrict(set2));
        }
        return newMap;
    }

    public T2VMap<T, S, V> reverse(T2VMap<T, S, V> newMap) {
        for (Map.Entry<S, TVMap<T, V>> e1 : this.maps.entrySet()) {
            S key1 = e1.getKey();
            TVMap<T, V> map = e1.getValue();
            for (TVMap.Entry e2 : map) {
                Object key2 = e2.getKey();
                Object value = e2.getValue();
                newMap.put(key2, key1, value);
            }
        }
        return newMap;
    }

    @Override
    public void lock() {
        for (TVMap<T, V> map : this.maps.values()) {
            map.lock();
        }
    }

    @Override
    public void switchToSortedList() {
        for (TVMap<T, V> map : this.maps.values()) {
            map.switchToSortedList();
        }
    }

    public void switchToHashTable() {
        for (TVMap<T, V> map : this.maps.values()) {
            map.switchToHashTable();
        }
    }

    protected T2VMap<S, T, V> newMap() {
        return new T2VMap<S, T, V>(this.keyFunc, this.valueFunc);
    }

    public TVMap<T, V> getMap(S key1, boolean modify) {
        if (key1 == this.lastKey) {
            return this.lastMap;
        }
        TVMap<T, V> map = this.maps.get(key1);
        if (map != null) {
            return map;
        }
        if (modify) {
            if (this.locked) {
                throw new RuntimeException("Cannot make new entry for " + key1 + ", because map is locked");
            }
            map = new TVMap(this.keyFunc, this.valueFunc);
            this.maps.put(key1, map);
            this.lastKey = key1;
            this.lastMap = map;
            return map;
        }
        return null;
    }
}

