/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import fig.basic.Fmt;

public class StatFig {
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;
    private Object minKey;
    private Object maxKey;
    private double sum;
    private double sumsq;
    private int count;

    public void add(boolean x) {
        this.add(x ? 1 : 0);
    }

    public void add(double x) {
        this.add(null, x);
    }

    public void add(Object key, double x) {
        ++this.count;
        this.sum += x;
        this.sumsq += x * x;
        if (x < this.min) {
            this.min = x;
            this.minKey = key;
        }
        if (x > this.max) {
            this.max = x;
            this.maxKey = key;
        }
    }

    public void add(StatFig fig) {
        this.count += fig.count;
        this.sum += fig.sum;
        this.sumsq += fig.sumsq;
        if (fig.min < this.min) {
            this.min = fig.min;
            this.minKey = fig.minKey;
        }
        if (fig.max > this.max) {
            this.max = fig.max;
            this.maxKey = fig.maxKey;
        }
    }

    public double count() {
        return this.count;
    }

    public double mean() {
        return this.sum / (double)this.count;
    }

    public double sum() {
        return this.sum;
    }

    public double variance() {
        return this.sumsq / (double)this.count - this.mean() * this.mean();
    }

    public double stddev() {
        return Math.sqrt(this.variance());
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public Object minKey() {
        return this.minKey;
    }

    public Object maxKey() {
        return this.maxKey;
    }

    public double range() {
        return this.max - this.min;
    }

    public String toString() {
        if (this.count == 0) {
            return "NaN (0)";
        }
        return String.valueOf(this.render(this.min, this.minKey)) + "/ << " + Fmt.D(this.mean()) + " ~ " + Fmt.D(this.stddev()) + " >> /" + this.render(this.max, this.maxKey) + " (" + this.count + ")";
    }

    private String render(double x, Object key) {
        return String.valueOf(Fmt.D(x)) + (key == null ? "" : "@" + key);
    }
}

