import json
import os
from sys import argv
def summary(fname):
    if fname == 'result/EMPTY': return 
    data = json.loads(open(fname).read().strip())
    dev = data['acc_dev']
    test = data['acc_test']
    #if len(dev) < int(argv[1]): 
    #    return ''
    #keys = ['binary-root', 'binary-all', 'fine-grained-root', 'fine-grained-all']
    fname = fname[7:-4]
    if fname[0] == '2':
        keys = ['binary']
    else:
        keys = ['binary', 'fine-grained']
    result = ''
    for key in keys:
        now = [(dev[i][key], test[i][key], i) for i in xrange(len(dev))][:int(argv[1])]
        now.sort(key = lambda x : x[0] + x[1] * 0.000001, reverse=True)
        best_dev = now[0]
        now.sort(key = lambda x : x[1], reverse=True)
        best_test = now[0]
        result += '%s: %.3f(%.3f/%.3f/%d) ' \
                % (key, best_dev[1], best_dev[0], best_test[1], best_dev[2])
    print fname, result
    #result += '<a href="/view.html?name=%s#fine-grained-root" style="margin-left:20px">%s</a>' % (fname, fname)
    #return '<p style="margin-bottom:3px">' + result+'</p>\n'
flist = os.listdir('result')
for fname in flist:
    summary('result/%s' % fname)
