/*
 * Decompiled with CFR 0.152.
 */
package jigsaw.treebank;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jigsaw.syntax.Tree;
import jigsaw.treebank.NumberRangeFileFilter;
import jigsaw.treebank.Trees;
import jigsaw.util.ConcatenationIterator;

public class PennTreebankReader {
    public static Collection<Tree<String>> readTrees(String path) {
        return PennTreebankReader.readTrees(path, -1, Integer.MAX_VALUE);
    }

    public static Collection<Tree<String>> readTrees(String path, int lowFileNum, int highFileNumber) {
        return new TreeCollection(path, lowFileNum, highFileNumber);
    }

    public static void main(String[] args) {
        Collection<Tree<String>> trees = PennTreebankReader.readTrees(args[0]);
        for (Tree<String> tree : trees) {
            tree = new Trees.StandardTreeNormalizer().transformTree(tree);
            System.out.println(Trees.PennTreeRenderer.render(tree));
        }
    }

    static class TreeCollection
    extends AbstractCollection<Tree<String>> {
        List<File> files;

        @Override
        public Iterator<Tree<String>> iterator() {
            return new ConcatenationIterator<Tree<String>>(new TreeIteratorIterator(this.files));
        }

        @Override
        public int size() {
            int size = 0;
            Iterator<Tree<String>> i = this.iterator();
            while (i.hasNext()) {
                ++size;
                i.next();
            }
            return size;
        }

        private List<File> getFilesUnder(String path, FileFilter fileFilter) {
            File root = new File(path);
            ArrayList<File> files = new ArrayList<File>();
            this.addFilesUnder(root, files, fileFilter);
            return files;
        }

        private void addFilesUnder(File root, List<File> files, FileFilter fileFilter) {
            if (!fileFilter.accept(root)) {
                return;
            }
            if (root.isFile()) {
                files.add(root);
                return;
            }
            if (root.isDirectory()) {
                File[] children = root.listFiles();
                int i = 0;
                while (i < children.length) {
                    File child = children[i];
                    this.addFilesUnder(child, files, fileFilter);
                    ++i;
                }
            }
        }

        public TreeCollection(String path, int lowFileNum, int highFileNum) {
            this(path, lowFileNum, highFileNum, ".mrg");
        }

        public TreeCollection(String path, int lowFileNum, int highFileNum, String suffix) {
            NumberRangeFileFilter fileFilter = new NumberRangeFileFilter(suffix, lowFileNum, highFileNum, true);
            this.files = this.getFilesUnder(path, fileFilter);
            Collections.sort(this.files);
        }

        static class TreeIteratorIterator
        implements Iterator<Iterator<Tree<String>>> {
            Iterator<File> fileIterator;
            Iterator<Tree<String>> nextTreeIterator;

            @Override
            public boolean hasNext() {
                return this.nextTreeIterator != null;
            }

            @Override
            public Iterator<Tree<String>> next() {
                Iterator<Tree<String>> currentTreeIterator = this.nextTreeIterator;
                this.advance();
                return currentTreeIterator;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void advance() {
                this.nextTreeIterator = null;
                while (this.nextTreeIterator == null && this.fileIterator.hasNext()) {
                    try {
                        File file = this.fileIterator.next();
                        this.nextTreeIterator = new Trees.PennTreeReader(new BufferedReader(new FileReader(file)));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
            }

            TreeIteratorIterator(List<File> files) {
                this.fileIterator = files.iterator();
                this.advance();
            }
        }
    }
}

