/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.record.Matcher;
import fig.record.VarBindingList;
import java.util.regex.Pattern;

public class RegexMatcher
implements Matcher {
    private Pattern pattern;
    private String patternStr;

    public RegexMatcher(String patternStr) {
        this.patternStr = patternStr;
        if (!VarBindingList.containsVar(patternStr)) {
            this.pattern = RegexMatcher.convert(patternStr);
        }
    }

    @Override
    public boolean matches(String s, VarBindingList bindings) {
        Pattern pattern = this.pattern;
        if (pattern == null) {
            pattern = RegexMatcher.convert(bindings.substitute(this.patternStr));
        }
        return pattern.matcher(s).matches();
    }

    public String toString() {
        return this.patternStr;
    }

    private static Pattern convert(String patternStr) {
        return Pattern.compile(patternStr);
    }
}

