/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.basic.Exceptions;
import fig.basic.Utils;
import fig.record.Matcher;
import fig.record.VarBindingList;

public class NumMatcher
implements Matcher {
    private Op op;
    private String targetStr;
    private double target;

    private static Op getOp(String s) {
        if (s.equals("==")) {
            return Op.equals;
        }
        if (s.equals("<")) {
            return Op.lessThan;
        }
        if (s.equals(">")) {
            return Op.greaterThan;
        }
        if (s.equals("<=")) {
            return Op.lessThanEquals;
        }
        if (s.equals(">=")) {
            return Op.greaterThanEquals;
        }
        throw Exceptions.unknownCase;
    }

    public NumMatcher(String opStr, String targetStr) {
        this.op = NumMatcher.getOp(opStr);
        this.targetStr = targetStr;
        this.target = !VarBindingList.containsVar(targetStr) ? NumMatcher.convert(targetStr) : Double.NaN;
    }

    @Override
    public boolean matches(String s, VarBindingList bindings) {
        double x = Double.parseDouble(s);
        double target = this.target;
        if (Double.isNaN(target)) {
            target = NumMatcher.convert(bindings.substitute(this.targetStr));
        }
        switch (this.op) {
            case equals: {
                return Math.abs(x - target) < 1.0E-10;
            }
            case lessThan: {
                return x < target;
            }
            case greaterThan: {
                return x > target;
            }
            case lessThanEquals: {
                return x <= target;
            }
            case greaterThanEquals: {
                return x >= target;
            }
        }
        throw new RuntimeException("Unknown case");
    }

    private static double convert(String targetStr) {
        return Utils.parseDoubleEasy(targetStr);
    }

    public String toString() {
        return (Object)((Object)this.op) + "(" + this.targetStr + ")";
    }

    public static enum Op {
        equals,
        lessThan,
        greaterThan,
        lessThanEquals,
        greaterThanEquals;

    }
}

