/*
 * Decompiled with CFR 0.152.
 */
package fig.prob;

import fig.basic.Exceptions;
import fig.basic.NumUtils;
import fig.basic.TDoubleMap;
import fig.prob.Distrib;
import fig.prob.SparseDirichlet;
import fig.prob.SparseDirichletInterface;
import fig.prob.SuffStats;
import java.util.Random;

public class DegenerateSparseDirichlet
implements SparseDirichletInterface {
    private SparseDirichlet parent;

    public DegenerateSparseDirichlet(SparseDirichlet parent) {
        this.parent = parent;
    }

    @Override
    public int dim() {
        return this.parent.dim();
    }

    @Override
    public double getMean(Object key) {
        return this.parent.getMode(key);
    }

    @Override
    public double getMode(Object key) {
        return this.parent.getMode(key);
    }

    @Override
    public double getConcentration(Object key) {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double totalCount() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double expectedLog(Object key) {
        return Math.log(this.getMode(key));
    }

    @Override
    public TDoubleMap sampleObject(Random random) {
        throw Exceptions.unsupported;
    }

    @Override
    public double logProb(SuffStats stats) {
        throw Exceptions.unsupported;
    }

    @Override
    public double logProbObject(TDoubleMap x) {
        throw Exceptions.unsupported;
    }

    @Override
    public double crossEntropy(Distrib<TDoubleMap> _that) {
        double thatCon;
        double thisCon;
        if (_that instanceof DegenerateSparseDirichlet) {
            return 0.0;
        }
        SparseDirichlet that = (SparseDirichlet)_that;
        double sum = NumUtils.logGamma(that.totalCount());
        int numDimHandled = 0;
        for (TDoubleMap.Entry e : this.parent.counts) {
            thisCon = this.getMode(e.getKey());
            thatCon = that.pseudoCount + that.counts.get(e.getKey(), 0.0);
            sum += (thatCon - 1.0) * Math.log(thisCon) - NumUtils.logGamma(thatCon);
            ++numDimHandled;
        }
        for (TDoubleMap.Entry e : that.counts) {
            if (this.parent.counts.containsKey(e.getKey())) continue;
            thisCon = this.getMode(e.getKey());
            thatCon = that.pseudoCount + e.getValue();
            sum += (thatCon - 1.0) * Math.log(thisCon) - NumUtils.logGamma(thatCon);
            ++numDimHandled;
        }
        if (numDimHandled > this.parent.numDim) {
            throw new RuntimeException("numDim is too small");
        }
        double thisCon2 = SparseDirichlet.getMode(this.parent.pseudoCount, this.parent.pseudoCount, this.parent.totalCount(), this.dim());
        double thatCon2 = that.pseudoCount;
        NumUtils.assertIsFinite(sum += (double)(this.parent.numDim - numDimHandled) * ((thatCon2 - 1.0) * Math.log(thisCon2) - NumUtils.logGamma(thatCon2)));
        return sum;
    }

    @Override
    public SparseDirichletInterface modeSpike() {
        return this;
    }

    public String toString() {
        return "Degenerate" + this.parent;
    }
}

