/*
 * Decompiled with CFR 0.152.
 */
package LinguaView.syntax;

import LinguaView.TreePanel;
import LinguaView.syntax.CCGInternalNode;
import LinguaView.syntax.CCGNode;
import LinguaView.syntax.CCGTerminalNode;
import LinguaView.syntax.CategoryObject;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;

public class CCGTreePanel
extends TreePanel<CCGNode> {
    int sentenceLength;
    int nodesCount;
    int maxDepth;
    IdentityHashMap<CCGNode, Integer> indexTable;
    CCGNode[] nodesArray;
    CCGTerminalNode[] lexicalsArray;
    String[] labelArray;
    int[] XLeftArray;
    int[] YArray;
    int[] XMiddleArray;
    int[] XLabelLeftArray;
    int[] graphicalHeightArray;
    int[] nodeLengthsArray;

    @Override
    public void init() {
        this.levelSizeFactor = 1.5;
        this.loadFont();
        this.loadSentence();
        this.setPreferredSize(this.area);
        this.setSize(this.area);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void loadSentence() {
        int i;
        CCGTerminalNode n;
        CCGNode headNode = (CCGNode)this.treebank.get(this.sentenceNumber);
        if (headNode instanceof CCGTerminalNode && ((CCGTerminalNode)headNode).categoryToString().equals("_")) {
            this.sentenceLength = 0;
            this.nodesCount = 0;
            this.maxDepth = 0;
            this.indexTable = null;
            this.nodesArray = null;
            this.lexicalsArray = null;
            this.labelArray = null;
            this.XLeftArray = null;
            this.YArray = null;
            this.XMiddleArray = null;
            this.XLabelLeftArray = null;
            this.graphicalHeightArray = null;
            this.nodeLengthsArray = null;
            this.area.height = 0;
            this.area.width = 0;
            return;
        }
        this.indexTable = new IdentityHashMap();
        this.nodesCount = headNode.countAllNodes();
        this.sentenceLength = headNode.countTerminalNodes();
        List<CCGNode> nodesList = headNode.collectAllNodes();
        this.nodesArray = new CCGNode[nodesList.size()];
        nodesList.toArray(this.nodesArray);
        List<CCGTerminalNode> lexicalsList = headNode.collectTerminalNodes();
        this.lexicalsArray = new CCGTerminalNode[lexicalsList.size()];
        lexicalsList.toArray(this.lexicalsArray);
        this.maxDepth = headNode.maxDepth();
        int i2 = 0;
        while (i2 < this.nodesCount) {
            CCGNode n2 = this.nodesArray[i2];
            this.indexTable.put(n2, i2);
            ++i2;
        }
        this.labelArray = new String[this.nodesCount];
        this.XLeftArray = new int[this.nodesCount];
        this.XMiddleArray = new int[this.nodesCount];
        this.XLabelLeftArray = new int[this.nodesCount];
        this.graphicalHeightArray = new int[this.nodesCount];
        this.nodeLengthsArray = new int[this.nodesCount];
        Arrays.fill(this.XLeftArray, -1);
        this.YArray = new int[this.nodesCount];
        int treeWidth = 0;
        int previousWordLength = 0;
        int previousXLeft = this.leftMargin;
        int j = 0;
        while (j < this.sentenceLength) {
            int wordLength;
            n = this.lexicalsArray[j];
            i = this.indexTable.get(n);
            this.labelArray[i] = n.categoryWithNoFeature();
            int labelLength = this.metrics.stringWidth(this.labelArray[i]);
            this.nodeLengthsArray[i] = labelLength > (wordLength = this.metrics.stringWidth(n.word())) ? labelLength : wordLength;
            this.XMiddleArray[i] = previousXLeft + previousWordLength + this.wordSpace + this.nodeLengthsArray[i] / 2;
            this.XLeftArray[i] = this.XMiddleArray[i] - this.nodeLengthsArray[i] / 2;
            this.XLabelLeftArray[i] = this.XMiddleArray[i] - labelLength / 2;
            this.graphicalHeightArray[i] = this.maxDepth;
            previousWordLength = this.nodeLengthsArray[i];
            previousXLeft = this.XLeftArray[i];
            ++j;
        }
        if (headNode instanceof CCGInternalNode) {
            this.updateValues((CCGInternalNode)headNode);
        }
        j = 0;
        while (j < this.sentenceLength) {
            n = this.lexicalsArray[j];
            i = this.indexTable.get(n);
            this.YArray[i] = (int)((double)(this.topMargin + this.fontHight) + this.levelSize);
            ++j;
        }
        int RightMostNodeIndex = this.getMaximalIndex(this.XLeftArray);
        treeWidth = this.XLeftArray[RightMostNodeIndex] + this.nodeLengthsArray[RightMostNodeIndex] + this.wordSpace;
        int treeHeight = (int)((double)(this.topMargin + this.fontHight) + (double)(this.maxDepth + 1) * this.levelSize + (double)this.bottomMargin);
        this.area.width = treeWidth += this.rightMargin;
        this.area.height = treeHeight;
    }

    @Override
    public void render(Graphics2D g2) {
        g2.setFont(this.font);
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke());
        CCGNode headNode = (CCGNode)this.treebank.get(this.sentenceNumber);
        this.drawNodes(headNode, g2);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.render(g2);
    }

    private void drawNodes(CCGNode n, Graphics2D g2) {
        if (this.indexTable == null) {
            return;
        }
        int i = this.indexTable.get(n);
        if (n instanceof CCGInternalNode) {
            CCGInternalNode ni = (CCGInternalNode)n;
            String catDisplay = ni.categoryWithNoFeature();
            catDisplay = catDisplay.replace('{', '(');
            catDisplay = catDisplay.replace('}', ')');
            g2.drawString(catDisplay, this.XLabelLeftArray[i], this.YArray[i]);
            int lineY = (int)((double)this.YArray[i] - (this.levelSize + (double)this.fontSize) / 2.0);
            if (ni.prole() == 1) {
                int i_ = this.indexTable.get(ni.daughters()[0]);
                if (CategoryObject.typeRaising(ni.category(), n.category(), null)) {
                    if (n.category().isForward()) {
                        this.drawTypeRaisingArrow(this.XLeftArray[i_], this.XLeftArray[i_] + this.nodeLengthsArray[i_], lineY, true, g2);
                    } else {
                        this.drawTypeRaisingArrow(this.XLeftArray[i_], this.XLeftArray[i_] + this.nodeLengthsArray[i_], lineY, false, g2);
                    }
                } else {
                    g2.drawLine(this.XLeftArray[i_], lineY, this.XLeftArray[i_] + this.nodeLengthsArray[i_], lineY);
                }
                this.drawNodes(this.nodesArray[i_], g2);
            } else if (ni.prole() == 2) {
                CCGNode[] children = ((CCGInternalNode)n).daughters();
                int[] XChildrenLeft = new int[children.length];
                int j = 0;
                CCGNode[] cCGNodeArray = children;
                int n2 = children.length;
                int n3 = 0;
                while (n3 < n2) {
                    CCGNode c = cCGNodeArray[n3];
                    XChildrenLeft[j] = this.XLeftArray[this.indexTable.get(c)];
                    ++j;
                    ++n3;
                }
                int LeftMostChild = this.indexTable.get(children[this.getMinimalIndex(XChildrenLeft)]);
                int RightMostChild = this.indexTable.get(children[this.getMaximalIndex(XChildrenLeft)]);
                int x1 = this.XLeftArray[LeftMostChild];
                int x2 = this.XLeftArray[RightMostChild] + this.nodeLengthsArray[RightMostChild];
                if (CategoryObject.forwardApply(this.nodesArray[LeftMostChild].category(), this.nodesArray[RightMostChild].category(), n.category(), null)) {
                    this.drawArrow(x1, x2, lineY, true, g2);
                } else if (CategoryObject.backwardApply(this.nodesArray[LeftMostChild].category(), this.nodesArray[RightMostChild].category(), n.category(), null)) {
                    this.drawArrow(x1, x2, lineY, false, g2);
                } else if (CategoryObject.simpleForwardCompose(this.nodesArray[LeftMostChild].category(), this.nodesArray[RightMostChild].category(), n.category(), null)) {
                    this.drawSimpleCompositionArrow(x1, x2, lineY, true, g2);
                } else if (CategoryObject.simpleBackwardCompose(this.nodesArray[LeftMostChild].category(), this.nodesArray[RightMostChild].category(), n.category(), null)) {
                    this.drawSimpleCompositionArrow(x1, x2, lineY, false, g2);
                } else if (CategoryObject.crossForwardCompose(this.nodesArray[LeftMostChild].category(), this.nodesArray[RightMostChild].category(), n.category(), null)) {
                    this.drawSimpleCompositionArrow(x1, x2, lineY, true, g2);
                } else if (CategoryObject.crossBackwardCompose(this.nodesArray[LeftMostChild].category(), this.nodesArray[RightMostChild].category(), n.category(), null)) {
                    this.drawSimpleCompositionArrow(x1, x2, lineY, false, g2);
                } else if (CategoryObject.generalizedForwardCompose(this.nodesArray[LeftMostChild].category(), this.nodesArray[RightMostChild].category(), n.category(), null)) {
                    this.drawGeneralizedCompositionArrow(x1, x2, lineY, true, false, g2);
                } else if (CategoryObject.generalizedBackwardCompose(this.nodesArray[LeftMostChild].category(), this.nodesArray[RightMostChild].category(), n.category(), null)) {
                    this.drawGeneralizedCompositionArrow(x1, x2, lineY, false, false, g2);
                } else if (CategoryObject.generalizedForwardCrossCompose(this.nodesArray[LeftMostChild].category(), this.nodesArray[RightMostChild].category(), n.category(), null)) {
                    this.drawGeneralizedCompositionArrow(x1, x2, lineY, true, true, g2);
                } else if (CategoryObject.generalizedBackwardCrossCompose(this.nodesArray[LeftMostChild].category(), this.nodesArray[RightMostChild].category(), n.category(), null)) {
                    this.drawGeneralizedCompositionArrow(x1, x2, lineY, true, true, g2);
                } else if (CategoryObject.forwardSubstitute(this.nodesArray[LeftMostChild].category(), this.nodesArray[RightMostChild].category(), n.category(), null)) {
                    this.drawSubstitutionArrow(x1, x2, lineY, true, g2);
                } else if (CategoryObject.backwardSubstitute(this.nodesArray[LeftMostChild].category(), this.nodesArray[RightMostChild].category(), n.category(), null)) {
                    this.drawSubstitutionArrow(x1, x2, lineY, false, g2);
                } else if (CategoryObject.coordination(this.nodesArray[LeftMostChild].category(), this.nodesArray[RightMostChild].category(), n.category(), null)) {
                    this.drawClusterCoordinationArrow(x1, x2, lineY, g2);
                }
                CCGNode[] cCGNodeArray2 = children;
                int n4 = children.length;
                int n5 = 0;
                while (n5 < n4) {
                    CCGNode c = cCGNodeArray2[n5];
                    this.drawNodes(c, g2);
                    ++n5;
                }
            }
        } else {
            CCGTerminalNode ni = (CCGTerminalNode)n;
            String catDisplay = ni.categoryWithNoFeature();
            catDisplay = catDisplay.replace('{', '(');
            catDisplay = catDisplay.replace('}', ')');
            g2.drawString(catDisplay, this.XLabelLeftArray[i], this.YArray[i]);
            int lineY = (int)((double)this.YArray[i] - (this.levelSize + (double)this.fontHight) / 2.0);
            g2.drawLine(this.XLeftArray[i], lineY, this.XLeftArray[i] + this.nodeLengthsArray[i], lineY);
            int wordY = (int)((double)this.YArray[i] - this.levelSize);
            g2.drawString(ni.word(), this.XMiddleArray[i] - this.metrics.stringWidth(ni.word()) / 2, wordY);
        }
    }

    private void drawArrow(int x1, int x2, int y, boolean dir, Graphics2D g2) {
        Font fontOrig = g2.getFont();
        int sizeOrig = fontOrig.getSize();
        Font fontTag = new Font(fontOrig.getName(), 1, (int)((double)sizeOrig * 0.8));
        this.metrics = this.getFontMetrics(fontTag);
        int x2p = x2 - this.metrics.stringWidth(">");
        g2.setFont(fontTag);
        g2.drawLine(x1, y, x2p, y);
        if (dir) {
            g2.drawString(">", x2p, (int)((double)y + (double)this.metrics.getHeight() * 0.3));
        } else {
            g2.drawString("<", x2p, (int)((double)y + (double)this.metrics.getHeight() * 0.3));
        }
        this.metrics = this.getFontMetrics(fontOrig);
        g2.setFont(fontOrig);
    }

    private void drawTypeRaisingArrow(int x1, int x2, int y, boolean dir, Graphics2D g2) {
        Font fontOrig = g2.getFont();
        int sizeOrig = fontOrig.getSize();
        Font fontTag = new Font(fontOrig.getName(), 1, (int)((double)sizeOrig * 0.8));
        this.metrics = this.getFontMetrics(fontTag);
        int x2p = x2 - this.metrics.stringWidth(">T");
        g2.setFont(fontTag);
        g2.drawLine(x1, y, x2p, y);
        if (dir) {
            g2.drawString(">T", x2p, (int)((double)y + (double)this.metrics.getHeight() * 0.3));
        } else {
            g2.drawString("<T", x2p, (int)((double)y + (double)this.metrics.getHeight() * 0.3));
        }
        this.metrics = this.getFontMetrics(fontOrig);
        g2.setFont(fontOrig);
    }

    private void drawSimpleCompositionArrow(int x1, int x2, int y, boolean dir, Graphics2D g2) {
        Font fontOrig = g2.getFont();
        int sizeOrig = fontOrig.getSize();
        Font fontTag = new Font(fontOrig.getName(), 1, (int)((double)sizeOrig * 0.8));
        this.metrics = this.getFontMetrics(fontTag);
        int x2p = x2 - this.metrics.stringWidth(">B");
        g2.setFont(fontTag);
        g2.drawLine(x1, y, x2p, y);
        if (dir) {
            g2.drawString(">B", x2p, (int)((double)y + (double)this.metrics.getHeight() * 0.3));
        } else {
            g2.drawString("<B", x2p, (int)((double)y + (double)this.metrics.getHeight() * 0.3));
        }
        this.metrics = this.getFontMetrics(fontOrig);
        g2.setFont(fontOrig);
    }

    private void drawGeneralizedCompositionArrow(int x1, int x2, int y, boolean dir, boolean crossing, Graphics2D g2) {
        Font fontOrig = g2.getFont();
        int sizeOrig = fontOrig.getSize();
        Font fontTag = new Font(fontOrig.getName(), 1, (int)((double)sizeOrig * 0.8));
        Font fontSmallTag = new Font(fontOrig.getName(), 0, (int)((double)sizeOrig * 0.4));
        this.metrics = this.getFontMetrics(fontSmallTag);
        int SmallFontHeight = this.metrics.getHeight();
        int x2p1 = 0;
        int x2p2 = 0;
        int x2p3 = 0;
        if (crossing) {
            x2p1 = x2 - this.metrics.stringWidth(" x");
            x2p2 = x2p1 - this.metrics.stringWidth("+");
        } else {
            x2p2 = x2 - this.metrics.stringWidth("+");
        }
        this.metrics = this.getFontMetrics(fontTag);
        int FontHeight = this.metrics.getHeight();
        x2p3 = x2p2 - this.metrics.stringWidth(">B");
        g2.setFont(fontTag);
        g2.drawLine(x1, y, x2p3, y);
        if (dir) {
            g2.drawString(">B", x2p3, y + FontHeight / 2);
        } else {
            g2.drawString("<B", x2p3, y + FontHeight / 2);
        }
        g2.drawString("+", x2p2, y - FontHeight / 2 + SmallFontHeight);
        if (crossing) {
            g2.drawString(" x", x2p1, y);
        }
        this.metrics = this.getFontMetrics(fontOrig);
        g2.setFont(fontOrig);
    }

    private void drawSubstitutionArrow(int x1, int x2, int y, boolean dir, Graphics2D g2) {
        Font fontOrig = g2.getFont();
        int sizeOrig = fontOrig.getSize();
        Font fontTag = new Font(fontOrig.getName(), 1, (int)((double)sizeOrig * 0.8));
        this.metrics = this.getFontMetrics(fontTag);
        int x2p = x2 - this.metrics.stringWidth(">S");
        g2.setFont(fontTag);
        g2.drawLine(x1, y, x2p, y);
        if (dir) {
            g2.drawString(">S", x2p, (int)((double)y + (double)this.metrics.getHeight() * 0.3));
        } else {
            g2.drawString("<S", x2p, (int)((double)y + (double)this.metrics.getHeight() * 0.3));
        }
        this.metrics = this.getFontMetrics(fontOrig);
        g2.setFont(fontOrig);
    }

    private void drawClusterCoordinationArrow(int x1, int x2, int y, Graphics2D g2) {
        Font fontOrig = g2.getFont();
        int sizeOrig = fontOrig.getSize();
        Font fontTag = new Font(fontOrig.getName(), 1, (int)((double)sizeOrig * 0.8));
        this.metrics = this.getFontMetrics(fontTag);
        int x2p = x2 - this.metrics.stringWidth(">\u03a6");
        g2.setFont(fontTag);
        g2.drawLine(x1, y, x2p, y);
        g2.drawString(">\u03a6", x2p, (int)((double)y + (double)this.metrics.getHeight() * 0.3));
        this.metrics = this.getFontMetrics(fontOrig);
        g2.setFont(fontOrig);
    }

    public void updateValues(CCGInternalNode n) {
        CCGNode[] children = n.daughters();
        int[] XChildrenLeft = new int[children.length];
        int[] XChildrenRight = new int[children.length];
        int[] ChildrenHeight = new int[children.length];
        int i = 0;
        CCGNode[] cCGNodeArray = children;
        int n2 = children.length;
        int n3 = 0;
        while (n3 < n2) {
            CCGNode c = cCGNodeArray[n3];
            if (c instanceof CCGTerminalNode) {
                XChildrenLeft[i] = this.XLeftArray[this.indexTable.get(c)];
                XChildrenRight[i] = XChildrenLeft[i] + this.nodeLengthsArray[this.indexTable.get(c)];
                ChildrenHeight[i] = this.graphicalHeightArray[this.indexTable.get(c)];
                ++i;
            } else {
                this.updateValues((CCGInternalNode)c);
                XChildrenLeft[i] = this.XLeftArray[this.indexTable.get(c)];
                XChildrenRight[i] = XChildrenLeft[i] + this.nodeLengthsArray[this.indexTable.get(c)];
                ChildrenHeight[i] = this.graphicalHeightArray[this.indexTable.get(c)];
                ++i;
            }
            ++n3;
        }
        i = this.indexTable.get(n);
        this.labelArray[i] = n.categoryWithNoFeature();
        int labelLength = this.metrics.stringWidth(this.labelArray[i]);
        if (labelLength > this.getMaximal(XChildrenRight) - this.getMinimal(XChildrenLeft)) {
            int RightMostChildIndex = this.getMaximalIndex(XChildrenRight);
            CCGNode RightMostChild = children[RightMostChildIndex];
            int increment = labelLength - (this.getMaximal(XChildrenRight) - this.getMinimal(XChildrenLeft));
            if (children.length > 1) {
                int newXLeft = this.XLeftArray[this.indexTable.get(RightMostChild)] + increment;
                int newXRight = this.XLeftArray[this.indexTable.get(RightMostChild)] + this.nodeLengthsArray[this.indexTable.get(RightMostChild)] + increment;
                this.updateValues(RightMostChild, newXLeft, newXRight);
            } else {
                int newXLeft = this.XLeftArray[this.indexTable.get(RightMostChild)];
                int newXRight = this.XLeftArray[this.indexTable.get(RightMostChild)] + this.nodeLengthsArray[this.indexTable.get(RightMostChild)] + increment;
                this.updateValues(RightMostChild, newXLeft, newXRight);
            }
            this.nodeLengthsArray[i] = labelLength;
            this.XLeftArray[i] = this.getMinimal(XChildrenLeft);
        } else {
            this.nodeLengthsArray[i] = this.getMaximal(XChildrenRight) - this.getMinimal(XChildrenLeft);
            this.XLeftArray[i] = this.getMinimal(XChildrenLeft);
        }
        this.graphicalHeightArray[i] = this.getMinimal(ChildrenHeight) - 1;
        this.XMiddleArray[i] = this.XLeftArray[i] + this.nodeLengthsArray[i] / 2;
        this.XLabelLeftArray[i] = this.XMiddleArray[i] - labelLength / 2;
        this.YArray[i] = (int)((double)(this.topMargin + this.fontHight) + (double)(this.maxDepth - this.graphicalHeightArray[i] + 1) * this.levelSize);
    }

    public void updateValues(CCGNode n, int newXLeft, int newXRight) {
        int n2;
        int i = this.indexTable.get(n);
        int increment = newXRight - (this.XLeftArray[i] + this.nodeLengthsArray[i]);
        this.XLeftArray[i] = newXLeft;
        this.XMiddleArray[i] = (newXLeft + newXRight) / 2;
        this.nodeLengthsArray[i] = newXRight - newXLeft;
        this.XLabelLeftArray[i] = this.XMiddleArray[i] - this.metrics.stringWidth(this.labelArray[i]) / 2;
        int RightMostChildIndex = this.indexTable.get(n);
        CCGNode RightMostChild = n;
        if (n instanceof CCGInternalNode) {
            CCGNode[] children = ((CCGInternalNode)n).daughters();
            int[] XChildrenLeft = new int[children.length];
            i = 0;
            CCGNode[] cCGNodeArray = children;
            int n3 = children.length;
            n2 = 0;
            while (n2 < n3) {
                CCGNode c = cCGNodeArray[n2];
                XChildrenLeft[i] = this.XLeftArray[this.indexTable.get(c)];
                ++i;
                ++n2;
            }
            RightMostChildIndex = this.getMaximalIndex(XChildrenLeft);
            RightMostChild = children[RightMostChildIndex];
            if (children.length > 1) {
                newXLeft = newXRight - this.nodeLengthsArray[this.indexTable.get(RightMostChild)];
                this.updateValues(RightMostChild, newXLeft, newXRight);
            } else {
                this.updateValues(RightMostChild, newXLeft, newXRight);
            }
        }
        int XRightMostChild = this.XLeftArray[RightMostChildIndex] + this.nodeLengthsArray[RightMostChildIndex];
        CCGNode[] cCGNodeArray = this.nodesArray;
        n2 = this.nodesArray.length;
        int n4 = 0;
        while (n4 < n2) {
            CCGNode c = cCGNodeArray[n4];
            int j = this.indexTable.get(c);
            int XRight = this.XLeftArray[j] + this.nodeLengthsArray[j];
            if (n instanceof CCGTerminalNode && XRight > XRightMostChild) {
                int n5 = j;
                this.XLeftArray[n5] = this.XLeftArray[n5] + increment;
                int n6 = j;
                this.XMiddleArray[n6] = this.XMiddleArray[n6] + increment;
                int n7 = j;
                this.XLabelLeftArray[n7] = this.XLabelLeftArray[n7] + increment;
            }
            ++n4;
        }
    }

    public int getMinimal(int[] Array) {
        int min = Array[0];
        int[] nArray = Array;
        int n = Array.length;
        int n2 = 0;
        while (n2 < n) {
            int e = nArray[n2];
            if (e < min) {
                min = e;
            }
            ++n2;
        }
        return min;
    }

    public int getMinimalIndex(int[] Array) {
        int min = Array[0];
        int minIndex = 0;
        int i = 0;
        int[] nArray = Array;
        int n = Array.length;
        int n2 = 0;
        while (n2 < n) {
            int e = nArray[n2];
            if (e < min) {
                min = e;
                minIndex = i;
            }
            ++i;
            ++n2;
        }
        return minIndex;
    }

    public int getMaximal(int[] Array) {
        int min = Array[0];
        int[] nArray = Array;
        int n = Array.length;
        int n2 = 0;
        while (n2 < n) {
            int e = nArray[n2];
            if (e > min) {
                min = e;
            }
            ++n2;
        }
        return min;
    }

    public int getMaximalIndex(int[] Array) {
        int max = Array[0];
        int maxIndex = 0;
        int i = 0;
        int[] nArray = Array;
        int n = Array.length;
        int n2 = 0;
        while (n2 < n) {
            int e = nArray[n2];
            if (e > max) {
                max = e;
                maxIndex = i;
            }
            ++i;
            ++n2;
        }
        return maxIndex;
    }

    public int sum(int[] Array) {
        int sum = 0;
        int[] nArray = Array;
        int n = Array.length;
        int n2 = 0;
        while (n2 < n) {
            int e = nArray[n2];
            sum += e;
            ++n2;
        }
        return sum;
    }
}

