"""
Functions:
    This module offers language model score service. 
    It connects language model score server and return language model score of a given text.
Requirement:
    Setup Language model service (address and port), specified in README file.
Note:
    Change the settings accordingly to make it function.
"""
import os
import subprocess
import random

#TODO: "dip" reprents the actural server running SRILM trained trigram model.
cmd = " ngram -ppl - -use-server 2345@dip -cache-served-ngrams -debug 1 "
scorePrefix = "logprob= "

def getScore(result):
   """
   Hack the result to extract language model score (log) from the result string
   """
   s = result.find(scorePrefix)
   e = result.find(' ', s + len(scorePrefix))
   return float(result[s + len(scorePrefix):e])

def getLMScore(sen):
   p = subprocess.Popen(cmd,stdin=subprocess.PIPE, stdout=subprocess.PIPE, shell=True)
   standardOutput = p.communicate(input=sen)[0] 
   return getScore(standardOutput)

def getLMScoreBatch(senList):
   standardInput = "\n".join(senList)
   p = subprocess.Popen(cmd, stdin=subprocess.PIPE, stdout=subprocess.PIPE, shell=True)
   # hack the result, only the 3rd row is useful
   results = p.communicate(input=standardInput)[0].split("\n")[:-3]
   return [getScore(result) for i, result in enumerate(results) if i % 4 == 2]

if __name__ == "__main__" :
   print "Unit test"
   sen = "How are you"
   senList = []
   senList.append("I are from ZZZ University")
   senList.append("I graduate from XXX University")
   senList.append("His major is Computer Science")
   senList.append("she ain't so happy")
   senList.append("she ai n't so happy")
   senList.append("i'm bored somebody i.")
   senList.append("kim bored somebody i.")
   senList.append("i 'm bored somebody i.")

   print getLMScoreBatch(senList)
