/*
 * Decompiled with CFR 0.152.
 */
package babel.ranking.scorers.context;

import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.properties.context.Context;
import babel.content.eqclasses.properties.type.Type;
import babel.ranking.scorers.Scorer;
import babel.util.dict.Dictionary;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DictScorer
extends Scorer {
    protected static final Log LOG = LogFactory.getLog(DictScorer.class);
    protected Dictionary m_dict;

    public DictScorer(Dictionary dict) {
        this.m_dict = dict;
    }

    @Override
    public double score(EquivalenceClass srcEq, EquivalenceClass trgEq) {
        Context srcContext = (Context)srcEq.getProperty(Context.class.getName());
        Context trgContext = (Context)trgEq.getProperty(Context.class.getName());
        if (srcContext == null || trgContext == null || !srcContext.areContItemsScored() || !trgContext.areContItemsScored()) {
            throw new IllegalArgumentException("At least one of the classes has no or unscored context.");
        }
        double score = 0.0;
        double score1 = 0.0;
        double score2 = 0.0;
        HashSet<Long> unionContItemIds = srcContext.getContextualItemIds();
        unionContItemIds.addAll(trgContext.getContextualItemIds());
        for (Long contItemId : unionContItemIds) {
            double w1 = srcContext.getContextualItemScore(contItemId);
            double w2 = trgContext.getContextualItemScore(contItemId);
            score1 += w1 * w1;
            score2 += w2 * w2;
            score += w1 * w2;
        }
        return score1 * score2 == 0.0 ? 0.0 : score / Math.sqrt(score1 * score2);
    }

    @Override
    public boolean smallerScoresAreBetter() {
        return false;
    }

    protected abstract double scoreContItem(Context.ContextualItem var1, Type.EqType var2);

    @Override
    public void prepare(EquivalenceClass eq) {
        Type.EqType type = ((Type)eq.getProperty(Type.class.getName())).getType();
        Context context = (Context)eq.getProperty(Context.class.getName());
        if (context == null) {
            LOG.isWarnEnabled();
            context = new Context(eq);
            eq.setProperty(context);
        } else if (type == null || Type.EqType.NONE.equals((Object)type)) {
            throw new IllegalArgumentException("Class is of unknown type, cannot compute scores.");
        }
        Collection<Context.ContextualItem> cis = Type.EqType.SOURCE.equals((Object)type) ? this.m_dict.translateContext(eq) : context.getContextualItems();
        context.clear();
        for (Context.ContextualItem ci : cis) {
            double score = this.scoreContItem(ci, type);
            ci.setScore(score);
            Context.ContextualItem curCi = context.getContextualItem(ci.getContextEqId());
            if (curCi != null && (curCi == null || !(curCi.getScore() < score))) continue;
            context.setContextualItem(ci);
        }
        context.contItemsScored();
    }
}

