/*
 * Decompiled with CFR 0.152.
 */
package babel.ranking;

import babel.content.eqclasses.EquivalenceClass;
import babel.ranking.EquivClassCandRanking;
import babel.ranking.scorers.Scorer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Ranker {
    public static final Log LOG = LogFactory.getLog(Ranker.class);
    protected int m_numBest;
    protected double m_threshold;
    protected boolean m_useThreshold;
    protected Scorer m_scorer;
    protected int m_numThreads;
    protected List<Integer> m_workerIds;
    ArrayList<EquivClassCandRanking> m_curBestMatches;
    LinkedList<EquivalenceClass> m_curSrcEqsToProcess;
    int m_srcCount;
    int m_percentComplete;

    public Ranker(Scorer scorer, int numBest, double threshold, int numThreads) {
        if (numThreads < 1) {
            throw new IllegalArgumentException("Must request at least one thread");
        }
        this.m_numThreads = numThreads;
        this.m_useThreshold = true;
        this.m_threshold = threshold;
        this.m_numBest = numBest;
        this.m_scorer = scorer;
        this.m_workerIds = new ArrayList<Integer>(this.m_numThreads);
        this.m_curBestMatches = null;
    }

    public Ranker(Scorer scorer, int numBest, int numThreads) {
        this(scorer, numBest, 0.0, numThreads);
        this.m_useThreshold = false;
    }

    public String getId() {
        return this.m_scorer.getClass().getName();
    }

    public EquivClassCandRanking getBestCandList(EquivalenceClass srcEq, Collection<EquivalenceClass> trgEqs) {
        boolean smallerIsBetter = this.m_scorer.smallerScoresAreBetter();
        EquivClassCandRanking candSet = new EquivClassCandRanking(srcEq, this.m_numBest, smallerIsBetter);
        for (EquivalenceClass trgEq : trgEqs) {
            double score = this.m_scorer.score(srcEq, trgEq);
            if (this.m_useThreshold && (!this.m_useThreshold || !(smallerIsBetter && score < this.m_threshold) && (smallerIsBetter || !(score > this.m_threshold)))) continue;
            candSet.add(trgEq, score);
        }
        return candSet;
    }

    public synchronized Collection<EquivClassCandRanking> getBestCandLists(Collection<EquivalenceClass> srcEqs, Collection<EquivalenceClass> trgEqs) throws Exception {
        this.m_curBestMatches = new ArrayList(srcEqs.size());
        this.m_curSrcEqsToProcess = new LinkedList<EquivalenceClass>(srcEqs);
        this.m_workerIds.clear();
        this.m_percentComplete = 0;
        this.m_srcCount = srcEqs.size();
        int threadNum = 0;
        while (threadNum < this.m_numThreads) {
            this.m_workerIds.add(threadNum);
            new Thread(new RankerWorker(this, threadNum, trgEqs)).start();
            ++threadNum;
        }
        while (this.m_workerIds.size() > 0) {
            this.wait();
        }
        return this.m_curBestMatches;
    }

    protected synchronized EquivalenceClass getSrcEqToProcess() {
        return this.m_curSrcEqsToProcess.size() != 0 ? this.m_curSrcEqsToProcess.remove() : null;
    }

    protected synchronized void rankingDone(EquivClassCandRanking ranking) {
        this.m_curBestMatches.add(ranking);
        int newPercent = 100 * this.m_curBestMatches.size() / this.m_srcCount;
        if (newPercent % 5 == 0 && newPercent != this.m_percentComplete && LOG.isInfoEnabled()) {
            this.m_percentComplete = newPercent;
            LOG.info((Object)(String.valueOf(this.m_percentComplete) + "% done."));
        }
    }

    protected synchronized void workerDone(int workerID) {
        this.m_workerIds.remove(new Integer(workerID));
        this.notify();
    }

    class RankerWorker
    implements Runnable {
        protected Collection<EquivalenceClass> m_trgEqs;
        protected int m_workerId;
        protected Ranker m_ranker;

        public RankerWorker(Ranker ranker2, int workerId, Collection<EquivalenceClass> trgEqs) {
            this.m_workerId = workerId;
            this.m_ranker = ranker2;
            this.m_trgEqs = trgEqs;
        }

        @Override
        public void run() {
            EquivalenceClass srcEq;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Worker " + this.m_workerId + " started collecting rankings."));
            }
            while ((srcEq = this.m_ranker.getSrcEqToProcess()) != null) {
                this.m_ranker.rankingDone(this.m_ranker.getBestCandList(srcEq, this.m_trgEqs));
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Worker " + this.m_workerId + " finished."));
            }
            this.m_ranker.workerDone(this.m_workerId);
        }
    }
}

