/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses.properties.time;

import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.properties.Property;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class TimeDistribution
extends Property
implements Cloneable {
    protected HashMap<Integer, Double> m_bins = new HashMap();
    protected long m_count = 0L;
    protected boolean m_normalized = false;
    protected double m_sum = 0.0;
    protected double m_sumSquares = 0.0;

    public static TimeDistribution getUniformDistribution(int numWindows) {
        TimeDistribution distro = new TimeDistribution();
        distro.m_count = numWindows;
        int i = 0;
        while (i < numWindows) {
            distro.m_bins.put(i, new Double(1.0));
            ++i;
        }
        return distro;
    }

    public void removeBin(int binIdx) {
        if (this.m_normalized) {
            throw new IllegalStateException("TimeDistribution is normalized: cannot remove bins.");
        }
        Double count = this.m_bins.remove(binIdx);
        if (count != null) {
            this.m_count = (long)((double)this.m_count - count);
        }
    }

    public void removeBins(Set<Integer> binIdxs) {
        if (this.m_normalized) {
            throw new IllegalStateException("TimeDistribution is normalized: cannot remove bins.");
        }
        for (Integer binIdx : binIdxs) {
            Double count = this.m_bins.remove(binIdx);
            if (count == null) continue;
            this.m_count = (long)((double)this.m_count - count);
        }
    }

    public void addBin(int binIdx, int count) {
        if (this.m_normalized) {
            throw new IllegalStateException("TimeDistribution is normalized: cannot add more bins.");
        }
        if (count != 0) {
            this.m_bins.put(binIdx, new Double(count));
            this.m_count += (long)count;
        }
    }

    public String toString() {
        return "Distribution: bins = " + this.m_bins.size() + ", sum = " + this.m_sum + ", sum of squares = " + this.m_sumSquares + ", occurences = " + this.m_count + ", normalized = " + this.m_normalized;
    }

    public boolean isNormalized() {
        return this.m_normalized;
    }

    public void normalize() {
        if (!this.m_normalized) {
            double curValue = 0.0;
            this.m_sum = 0.0;
            this.m_sumSquares = 0.0;
            if (this.m_count != 0L) {
                for (Integer key : this.m_bins.keySet()) {
                    curValue = this.m_bins.get(key) / (double)this.m_count;
                    this.m_bins.put(key, new Double(curValue));
                    this.m_sum += curValue;
                    this.m_sumSquares += curValue * curValue;
                }
            }
            this.m_normalized = true;
        }
    }

    public HashMap<Integer, Double> getBins() {
        return this.m_bins;
    }

    public int getSize() {
        return this.m_bins.size();
    }

    public double getSum() {
        return this.m_sum;
    }

    public double getSumSquares() {
        return this.m_sumSquares;
    }

    public long getTotalOccurences() {
        return this.m_count;
    }

    public void reBin(int binSize, boolean slidingWindow) {
        if (this.m_normalized) {
            throw new IllegalArgumentException("Distribution must not be be normalized.");
        }
        if (binSize <= 0) {
            throw new IllegalArgumentException("Bin size must be positive.");
        }
        if (binSize == 1) {
            return;
        }
        int binStartIdx = 0;
        double newBinCount = 0.0;
        int newBinIdx = 0;
        int newTotalCount = 0;
        HashMap<Integer, Double> newBins = new HashMap<Integer, Double>();
        HashSet<Integer> seenBins = new HashSet<Integer>();
        while (this.m_bins.size() > seenBins.size()) {
            newBinCount = 0.0;
            int i = 0;
            while (i < binSize) {
                Double count = this.m_bins.get(binStartIdx + i);
                if (count != null) {
                    seenBins.add(binStartIdx + i);
                    newBinCount += count.doubleValue();
                }
                ++i;
            }
            if (newBinCount > 0.0) {
                newBins.put(newBinIdx, newBinCount);
                newTotalCount = (int)((double)newTotalCount + newBinCount);
            }
            ++newBinIdx;
            binStartIdx += slidingWindow ? 1 : binSize;
        }
        this.m_bins = newBins;
        this.m_count = newTotalCount;
    }

    public static TimeDistribution mergeDistros(TimeDistribution one, TimeDistribution two) {
        if (one.m_normalized || two.m_normalized) {
            throw new IllegalArgumentException("Distros must not be be normalized.");
        }
        TimeDistribution distro = new TimeDistribution();
        HashSet allKeys = new HashSet(one.m_bins.keySet());
        allKeys.addAll(two.m_bins.keySet());
        for (Integer key : allKeys) {
            Double curKeyCount = one.m_bins.get(key);
            double keyCount = curKeyCount == null ? 0.0 : curKeyCount;
            curKeyCount = two.m_bins.get(key);
            distro.m_bins.put(key, new Double(keyCount += curKeyCount == null ? 0.0 : curKeyCount));
        }
        distro.m_count = one.m_count + two.m_count;
        return distro;
    }

    @Override
    public String persistToString() {
        StringBuilder strBld = new StringBuilder();
        strBld.append(this.m_sum);
        strBld.append("\t");
        strBld.append(this.m_sumSquares);
        strBld.append("\t");
        strBld.append(this.m_count);
        strBld.append("\t");
        strBld.append(this.m_normalized);
        ArrayList keys = new ArrayList(this.m_bins.keySet());
        Collections.sort(keys);
        for (Integer key : keys) {
            strBld.append("\t");
            strBld.append(key + ":" + this.m_bins.get(key));
        }
        return strBld.toString();
    }

    @Override
    public void unpersistFromString(EquivalenceClass eq, String str) throws Exception {
        String[] toks = str.split("\t");
        this.m_sum = Double.parseDouble(toks[0]);
        this.m_sumSquares = Double.parseDouble(toks[1]);
        this.m_count = Long.parseLong(toks[2]);
        this.m_normalized = Boolean.parseBoolean(toks[3]);
        this.m_bins.clear();
        int i = 4;
        while (i < toks.length) {
            int idx = toks[i].indexOf(58);
            this.m_bins.put(Integer.parseInt(toks[i].substring(0, idx)), Double.parseDouble(toks[i].substring(idx + 1)));
            ++i;
        }
    }
}

