#!/usr/bin/env perl

use strict;
use utf8;
binmode STDIN, ":encoding(utf8)";
binmode STDERR, ":encoding(utf8)";
binmode STDOUT, ":encoding(utf8)";

if ( @ARGV != 1 ) {
    print STDERR "$0 <JUMAN.katuyou>\n";
    exit;
}
my %endings_;
&read_katuyou( $ARGV[0] );
&main();

sub main {

    my %dict;
    while ( <STDIN> ) {
	chomp;
	my ( $surface_form, $surface_reading, $surface_pos, $citation_form ) = split( /\t/, $_ );
	my ( $pos1, $pos2, $ctype, $cform ) = split( /,/, $surface_pos );
		
	if ( $ctype eq "*" ) {
	    $dict{"$surface_form\t$surface_pos\t$surface_form\t$surface_reading\t$surface_pos\t$citation_form"} = 1;
	}else {
	    for my$new_cform ( keys %{$endings_{$ctype}} ) {
		my $new_surface_form    = &transform( $surface_form, $ctype, $new_cform );
		my $new_surface_reading = &transform( $surface_reading, $ctype, $new_cform );
		my $new_surface_pos     = "$pos1,$pos2,$ctype,$new_cform";
		if ( 0 < length( $new_surface_form ) && 0 < length( $new_surface_reading ) ) {
		    $dict{"$new_surface_form\t$new_surface_pos\t$new_surface_form\t$new_surface_reading\t$new_surface_pos\t$citation_form"} = 1;
		}
	    }
	}
    }
    for ( sort { $a cmp $b } keys %dict ) {
	print "$_\n";
    }
}


sub read_katuyou {

    my ( $filename ) = @_;
    
    open( TEXT, $filename ) or die print STDERR "$filename\n";
    binmode( TEXT, ":encoding(utf8)" );
    while ( <TEXT> ) {
	chomp;
	if ( /^\((.+?)\(\((.+)\)\)\)$/ ) {
	    my $ctype = $1;
	    my @data = split( /\)\(/, $2 );
	    for my $data ( @data ) {
		my ( $cform, @endings ) = split( / /, $data );
		for my$ending ( @endings ) {
		    if ( $ending eq "*" ) {
			push( @{$endings_{$ctype}{$cform}}, "" );
		    }else {
			push( @{$endings_{$ctype}{$cform}}, $ending );
		    }
		}
	    }
	}else {
	    print STDERR "Error: $_\n";
	    exit;
	}
    }
    close( TEXT );
}


sub transform {

    my ( $basic_form, $ctype, $cform ) = @_;

    for ( my$i = 0; $i < @{$endings_{$ctype}{$cform}}; ++$i ) {
	if ( $basic_form =~ /(.*)$endings_{$ctype}{"基本形"}[$i]$/ ) {
	    return $1.$endings_{$ctype}{$cform}[$i];
	}
    }
    print STDERR "Error, $basic_form, $ctype, $cform\n";
    exit;
}
