/*
 	APS - Affinity Propagation for Segmentation, a linear text segmenter.
 
    Copyright (C) 2011, Anna Kazantseva

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
    */


package commandln;

public class IntParam extends ParamBase
{
	private Integer mValue = null;
	private Integer mDef = null;
	public IntParam(String name, Integer defValue)
	{
		super(name, defValue == null, true);
		mDef = defValue;
	}
	
	@Override
	public void ParseValue(String value) throws Exception 
	{
		mValue = Integer.parseInt(value);
	}

	@Override
	public int getInt() 
	{
		return (mValue == null ? mDef : mValue);
	}
}
