/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.symbol;

import com.aliasi.symbol.SymbolTable;
import com.aliasi.util.AbstractExternalizable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;

class CompiledSymbolTable
implements SymbolTable,
Serializable {
    static final long serialVersionUID = -8025428413920807070L;
    private final String[] mSymbols;

    public CompiledSymbolTable(String[] symbols) {
        this.mSymbols = new String[symbols.length];
        System.arraycopy(symbols, 0, this.mSymbols, 0, symbols.length);
        Arrays.sort(this.mSymbols);
    }

    private CompiledSymbolTable(String[] symbols, boolean ignore) {
        this.mSymbols = symbols;
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    public String toString() {
        return Arrays.asList(this.mSymbols).toString();
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.numSymbols());
        for (int i = 0; i < this.numSymbols(); ++i) {
            String symbol = this.idToSymbol(i);
            out.writeShort(symbol.length());
            out.writeChars(symbol);
        }
    }

    void writeObj(ObjectOutput out) throws IOException {
        out.writeInt(this.numSymbols());
        for (int i = 0; i < this.numSymbols(); ++i) {
            String symbol = this.idToSymbol(i);
            out.writeShort(symbol.length());
            out.writeChars(symbol);
        }
    }

    public int symbolToID(String symbol) {
        int result = Arrays.binarySearch(this.mSymbols, symbol);
        return result < 0 ? -1 : result;
    }

    public String idToSymbol(int id) {
        return this.mSymbols[id];
    }

    public int numSymbols() {
        return this.mSymbols.length;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public int getOrAddSymbol(String symbol) {
        throw new UnsupportedOperationException();
    }

    public int removeSymbol(String symbol) {
        throw new UnsupportedOperationException();
    }

    static class Serializer
    extends AbstractExternalizable {
        static final long serialVersionUID = 2115083345444042460L;
        private final CompiledSymbolTable mSymbolTable;
        static final boolean IGNORE = true;

        public Serializer(CompiledSymbolTable symbolTable) {
            this.mSymbolTable = symbolTable;
        }

        public Serializer() {
            this(null);
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.mSymbolTable.mSymbols.length);
            for (String symbol : this.mSymbolTable.mSymbols) {
                out.writeUTF(symbol);
            }
        }

        public Object read(ObjectInput in) throws ClassNotFoundException, IOException {
            int numSymbols = in.readInt();
            String[] symbols = new String[numSymbols];
            for (int i = 0; i < numSymbols; ++i) {
                symbols[i] = in.readUTF();
            }
            return new CompiledSymbolTable(symbols, true);
        }
    }
}

