/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.hmm;

import com.aliasi.corpus.ObjectHandler;
import com.aliasi.corpus.TagHandler;
import com.aliasi.hmm.AbstractHmm;
import com.aliasi.symbol.SymbolTable;
import com.aliasi.tag.Tagging;
import com.aliasi.util.Compilable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHmmEstimator
extends AbstractHmm
implements TagHandler,
ObjectHandler<Tagging<String>>,
Compilable {
    private long mNumTrainingTokens = 0L;
    private long mNumTrainingTaggings = 0L;

    public AbstractHmmEstimator(SymbolTable table) {
        super(table);
    }

    public abstract void trainStart(String var1);

    public abstract void trainEnd(String var1);

    public abstract void trainTransit(String var1, String var2);

    public abstract void trainEmit(String var1, CharSequence var2);

    @Override
    public abstract void compileTo(ObjectOutput var1) throws IOException;

    public long numTrainingCases() {
        return this.mNumTrainingTaggings;
    }

    public long numTrainingTokens() {
        return this.mNumTrainingTokens;
    }

    @Override
    @Deprecated
    public void handle(String[] toks, String[] whitespaces, String[] tags) {
        Tagging<String> tagging = new Tagging<String>(Arrays.asList(toks), Arrays.asList(tags));
        this.handle(tagging);
    }

    @Override
    public void handle(Tagging<String> tagging) {
        ++this.mNumTrainingTaggings;
        this.mNumTrainingTokens += (long)tagging.size();
        if (tagging.size() < 1) {
            return;
        }
        this.trainStart(tagging.tag(0));
        for (int i = 0; i < tagging.size(); ++i) {
            this.trainEmit(tagging.tag(i), tagging.token(i));
            if (i <= 0) continue;
            this.trainTransit(tagging.tag(i - 1), tagging.tag(i));
        }
        this.trainEnd(tagging.tag(tagging.size() - 1));
    }
}

