/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.classify;

import com.aliasi.classify.Classification;
import com.aliasi.classify.Classified;
import com.aliasi.classify.Classifier;
import com.aliasi.classify.ConditionalClassification;
import com.aliasi.classify.ConfusionMatrix;
import com.aliasi.classify.JointClassification;
import com.aliasi.classify.PrecisionRecallEvaluation;
import com.aliasi.classify.RankedClassification;
import com.aliasi.classify.ScoredClassification;
import com.aliasi.classify.ScoredPrecisionRecallEvaluation;
import com.aliasi.corpus.ClassificationHandler;
import com.aliasi.corpus.ObjectHandler;
import com.aliasi.util.Math;
import com.aliasi.util.Pair;
import com.aliasi.util.Scored;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class ClassifierEvaluator<E, C extends Classification>
implements ClassificationHandler<E, Classification>,
ObjectHandler<Classified<E>> {
    final boolean mStoreInputs;
    boolean mDefectiveRanking = false;
    boolean mDefectiveScoring = false;
    boolean mDefectiveConditioning = false;
    Classifier<E, ? extends C> mClassifier;
    private final ConfusionMatrix mConfusionMatrix;
    private int mNumCases = 0;
    final String[] mCategories;
    final Set<String> mCategorySet;
    final List<String> mReferenceCategories = new ArrayList<String>();
    final List<C> mClassifications = new ArrayList<C>();
    final List<E> mCases = new ArrayList();
    private boolean mHasRanked = false;
    private final int[][] mRankCounts;
    private boolean mHasScored = false;
    private final List<ScoreOutcome>[] mScoreOutcomeLists;
    private boolean mHasConditional = false;
    private final List<ScoreOutcome>[] mConditionalOutcomeLists;
    private boolean mHasJoint = false;
    private static final Comparator<Pair<?, ? extends Classification>> CASE_COMPARATOR = new CaseComparator();

    @Deprecated
    public ClassifierEvaluator(Classifier<E, ? extends C> classifier, String[] categories) {
        this(classifier, categories, false);
    }

    @Deprecated
    public ClassifierEvaluator(Classifier<E, ? extends C> classifier, String[] categories, boolean storeInputs) {
        this.mStoreInputs = storeInputs;
        this.mClassifier = classifier;
        this.mCategories = categories;
        this.mCategorySet = new HashSet<String>();
        Collections.addAll(this.mCategorySet, categories);
        this.mConfusionMatrix = new ConfusionMatrix(categories);
        int len = categories.length;
        this.mRankCounts = new int[len][len];
        ArrayList[] scoreOutcomeLists = new ArrayList[this.numCategories()];
        this.mScoreOutcomeLists = scoreOutcomeLists;
        for (int i = 0; i < this.mScoreOutcomeLists.length; ++i) {
            this.mScoreOutcomeLists[i] = new ArrayList<ScoreOutcome>();
        }
        ArrayList[] conditionalOutcomeLists = new ArrayList[this.numCategories()];
        this.mConditionalOutcomeLists = conditionalOutcomeLists;
        for (int i = 0; i < this.mConditionalOutcomeLists.length; ++i) {
            this.mConditionalOutcomeLists[i] = new ArrayList<ScoreOutcome>();
        }
    }

    @Deprecated
    public synchronized Classifier<E, ? extends C> classifier() {
        return this.mClassifier;
    }

    @Deprecated
    public synchronized void setClassifier(Classifier<E, ? extends C> classifier) {
        this.mClassifier = classifier;
    }

    public List<Pair<E, C>> truePositives(String category) {
        return this.caseTypes(category, true, true);
    }

    public List<Pair<E, C>> falsePositives(String category) {
        return this.caseTypes(category, false, true);
    }

    public List<Pair<E, C>> falseNegatives(String category) {
        return this.caseTypes(category, true, false);
    }

    public List<Pair<E, C>> trueNegatives(String category) {
        return this.caseTypes(category, false, false);
    }

    private List<Pair<E, C>> caseTypes(String category, boolean refMatch, boolean respMatch) {
        if (!this.mStoreInputs) {
            String msg = "Class must store items to return true positives. Use appropriate constructor flag to store.";
            throw new UnsupportedOperationException(msg);
        }
        ArrayList<Pair<Pair<E, Classification>, C>> result = new ArrayList<Pair<Pair<E, Classification>, C>>();
        for (int i = 0; i < this.mReferenceCategories.size(); ++i) {
            String refCat = this.mReferenceCategories.get(i);
            Classification c = (Classification)this.mClassifications.get(i);
            String respCat = c.bestCategory();
            if (category.equals(refCat) != refMatch || category.equals(respCat) != respMatch) continue;
            result.add(new Pair<E, Classification>(this.mCases.get(i), c));
        }
        Collections.sort(result, CASE_COMPARATOR);
        return result;
    }

    public String[] categories() {
        return this.mCategories;
    }

    @Deprecated
    public void addCase(String referenceCategory, E input) {
        this.validateCategory(referenceCategory);
        C classification = this.mClassifier.classify(input);
        this.addClassification(referenceCategory, classification, input);
    }

    @Override
    @Deprecated
    public void handle(E input, Classification classification) {
        this.addCase(classification.bestCategory(), input);
    }

    @Override
    public void handle(Classified<E> c) {
        this.handle(c.getObject(), c.getClassification());
    }

    public int numCases() {
        return this.mNumCases;
    }

    public ConfusionMatrix confusionMatrix() {
        return this.mConfusionMatrix;
    }

    public boolean missingRankings() {
        return this.mDefectiveRanking;
    }

    public boolean missingScorings() {
        return this.mDefectiveScoring;
    }

    public boolean missingConditionals() {
        return this.mDefectiveScoring;
    }

    public int rankCount(String referenceCategory, int rank) {
        this.validateCategory(referenceCategory);
        int i = this.categoryToIndex(referenceCategory);
        return this.rankCount(i, rank);
    }

    public double averageRankReference() {
        double sum = 0.0;
        int count = 0;
        for (int i = 0; i < this.numCategories(); ++i) {
            for (int rank = 0; rank < this.numCategories(); ++rank) {
                int rankCount = this.mRankCounts[i][rank];
                if (rankCount == 0) continue;
                count += rankCount;
                sum += (double)(rank * rankCount);
            }
        }
        return sum / (double)count;
    }

    public double meanReciprocalRank() {
        double sum = 0.0;
        int numCases = 0;
        for (int i = 0; i < this.numCategories(); ++i) {
            for (int rank = 0; rank < this.numCategories(); ++rank) {
                int rankCount = this.mRankCounts[i][rank];
                if (rankCount == 0) continue;
                numCases += rankCount;
                sum += (double)rankCount / (1.0 + (double)rank);
            }
        }
        return sum / (double)numCases;
    }

    public double averageConditionalProbability(String refCategory, String responseCategory) {
        this.validateCategory(refCategory);
        this.validateCategory(responseCategory);
        double sum = 0.0;
        int count = 0;
        block0: for (int i = 0; i < this.mReferenceCategories.size(); ++i) {
            if (!this.mReferenceCategories.get(i).equals(refCategory)) continue;
            ConditionalClassification c = (ConditionalClassification)this.mClassifications.get(i);
            for (int rank = 0; rank < c.size(); ++rank) {
                if (!c.category(rank).equals(responseCategory)) continue;
                sum += c.conditionalProbability(rank);
                ++count;
                continue block0;
            }
        }
        return sum / (double)count;
    }

    public double averageLog2JointProbability(String refCategory, String responseCategory) {
        this.validateCategory(refCategory);
        this.validateCategory(responseCategory);
        double sum = 0.0;
        int count = 0;
        block0: for (int i = 0; i < this.mReferenceCategories.size(); ++i) {
            if (!this.mReferenceCategories.get(i).equals(refCategory)) continue;
            JointClassification c = (JointClassification)this.mClassifications.get(i);
            for (int rank = 0; rank < c.size(); ++rank) {
                if (!c.category(rank).equals(responseCategory)) continue;
                sum += c.jointLog2Probability(rank);
                ++count;
                continue block0;
            }
        }
        return sum / (double)count;
    }

    public double corpusLog2JointProbability() {
        double total = 0.0;
        for (int i = 0; i < this.mClassifications.size(); ++i) {
            JointClassification c = (JointClassification)this.mClassifications.get(i);
            double maxJointLog2P = Double.NEGATIVE_INFINITY;
            for (int rank = 0; rank < c.size(); ++rank) {
                double jointLog2P = c.jointLog2Probability(rank);
                if (!(jointLog2P > maxJointLog2P)) continue;
                maxJointLog2P = jointLog2P;
            }
            double sum = 0.0;
            for (int rank = 0; rank < c.size(); ++rank) {
                sum += java.lang.Math.pow(2.0, c.jointLog2Probability(rank) - maxJointLog2P);
            }
            total += maxJointLog2P + Math.log2(sum);
        }
        return total;
    }

    public double averageScoreReference() {
        double sum = 0.0;
        block0: for (int i = 0; i < this.mReferenceCategories.size(); ++i) {
            String refCategory = this.mReferenceCategories.get(i).toString();
            ScoredClassification c = (ScoredClassification)this.mClassifications.get(i);
            for (int rank = 0; rank < c.size(); ++rank) {
                if (!c.category(rank).equals(refCategory)) continue;
                sum += c.score(rank);
                continue block0;
            }
        }
        return sum / (double)this.mReferenceCategories.size();
    }

    public double averageConditionalProbabilityReference() {
        double sum = 0.0;
        block0: for (int i = 0; i < this.mReferenceCategories.size(); ++i) {
            String refCategory = this.mReferenceCategories.get(i).toString();
            ConditionalClassification c = (ConditionalClassification)this.mClassifications.get(i);
            for (int rank = 0; rank < c.size(); ++rank) {
                if (!c.category(rank).equals(refCategory)) continue;
                sum += c.conditionalProbability(rank);
                continue block0;
            }
        }
        return sum / (double)this.mReferenceCategories.size();
    }

    public double averageLog2JointProbabilityReference() {
        double sum = 0.0;
        block0: for (int i = 0; i < this.mReferenceCategories.size(); ++i) {
            String refCategory = this.mReferenceCategories.get(i).toString();
            JointClassification c = (JointClassification)this.mClassifications.get(i);
            for (int rank = 0; rank < c.size(); ++rank) {
                if (!c.category(rank).equals(refCategory)) continue;
                sum += c.jointLog2Probability(rank);
                continue block0;
            }
        }
        return sum / (double)this.mReferenceCategories.size();
    }

    public double averageScore(String refCategory, String responseCategory) {
        this.validateCategory(refCategory);
        this.validateCategory(responseCategory);
        double sum = 0.0;
        int count = 0;
        block0: for (int i = 0; i < this.mReferenceCategories.size(); ++i) {
            if (!this.mReferenceCategories.get(i).equals(refCategory)) continue;
            ScoredClassification c = (ScoredClassification)this.mClassifications.get(i);
            for (int rank = 0; rank < c.size(); ++rank) {
                if (!c.category(rank).equals(responseCategory)) continue;
                sum += c.score(rank);
                ++count;
                continue block0;
            }
        }
        return sum / (double)count;
    }

    public double averageRank(String refCategory, String responseCategory) {
        this.validateCategory(refCategory);
        this.validateCategory(responseCategory);
        double sum = 0.0;
        int count = 0;
        for (int i = 0; i < this.mReferenceCategories.size(); ++i) {
            if (!this.mReferenceCategories.get(i).equals(refCategory)) continue;
            RankedClassification rankedClassification = (RankedClassification)this.mClassifications.get(i);
            int rank = this.getRank(rankedClassification, responseCategory);
            sum += (double)rank;
            ++count;
        }
        return sum / (double)count;
    }

    int getRank(RankedClassification classification, String responseCategory) {
        for (int rank = 0; rank < classification.size(); ++rank) {
            if (!classification.category(rank).equals(responseCategory)) continue;
            return rank;
        }
        return this.mCategories.length - 1;
    }

    public ScoredPrecisionRecallEvaluation scoredOneVersusAll(String refCategory) {
        this.validateCategory(refCategory);
        return this.scoredOneVersusAll(this.mScoreOutcomeLists, this.categoryToIndex(refCategory));
    }

    public ScoredPrecisionRecallEvaluation conditionalOneVersusAll(String refCategory) {
        this.validateCategory(refCategory);
        return this.scoredOneVersusAll(this.mConditionalOutcomeLists, this.categoryToIndex(refCategory));
    }

    public PrecisionRecallEvaluation oneVersusAll(String refCategory) {
        this.validateCategory(refCategory);
        PrecisionRecallEvaluation prEval = new PrecisionRecallEvaluation();
        int numCases = this.mReferenceCategories.size();
        for (int i = 0; i < numCases; ++i) {
            String caseRefCategory = this.mReferenceCategories.get(i);
            Classification response = (Classification)this.mClassifications.get(i);
            String caseResponseCategory = response.bestCategory();
            boolean inRef = caseRefCategory.equals(refCategory);
            boolean inResp = caseResponseCategory.equals(refCategory);
            prEval.addCase(inRef, inResp);
        }
        return prEval;
    }

    private ScoredPrecisionRecallEvaluation scoredOneVersusAll(List<ScoreOutcome>[] outcomeLists, int categoryIndex) {
        ScoredPrecisionRecallEvaluation eval = new ScoredPrecisionRecallEvaluation();
        for (ScoreOutcome outcome : outcomeLists[categoryIndex]) {
            eval.addCase(outcome.mOutcome, outcome.mScore);
        }
        return eval;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CLASSIFIER EVALUATION\n");
        this.mConfusionMatrix.toStringGlobal(sb);
        if (this.mHasRanked) {
            sb.append("Average Reference Rank=" + this.averageRankReference() + "\n");
        }
        if (this.mHasScored) {
            sb.append("Average Score Reference=" + this.averageScoreReference() + "\n");
        }
        if (this.mHasConditional) {
            sb.append("Average Conditional Probability Reference=" + this.averageConditionalProbabilityReference() + "\n");
        }
        if (this.mHasJoint) {
            sb.append("Average Log2 Joint Probability Reference=" + this.averageLog2JointProbabilityReference() + "\n");
        }
        sb.append("ONE VERSUS ALL EVALUATIONS BY CATEGORY\n");
        for (int i = 0; i < this.categories().length; ++i) {
            int j;
            String category = this.categories()[i];
            sb.append("\nCATEGORY[" + i + "]=" + category + "\n");
            sb.append("First-Best Precision/Recall Evaluation\n");
            sb.append(this.oneVersusAll(category));
            sb.append("\n");
            if (this.mHasRanked) {
                sb.append("Rank Histogram=\n");
                this.appendCategoryLine(sb);
                for (int rank = 0; rank < this.numCategories(); ++rank) {
                    if (rank > 0) {
                        sb.append(',');
                    }
                    sb.append(this.mRankCounts[i][rank]);
                }
                sb.append("\n");
                sb.append("Average Rank Histogram=\n");
                this.appendCategoryLine(sb);
                for (j = 0; j < this.numCategories(); ++j) {
                    if (j > 0) {
                        sb.append(',');
                    }
                    sb.append(this.averageRank(category, this.categories()[j]));
                }
                sb.append("\n");
            }
            if (this.mHasScored) {
                sb.append("Scored One Versus All\n");
                sb.append(this.scoredOneVersusAll(category).toString() + "\n");
                sb.append("Average Score Histogram=\n");
                this.appendCategoryLine(sb);
                for (j = 0; j < this.numCategories(); ++j) {
                    if (j > 0) {
                        sb.append(',');
                    }
                    sb.append(this.averageScore(category, this.categories()[j]));
                }
                sb.append("\n");
            }
            if (this.mHasConditional) {
                sb.append("Conditional One Versus All\n");
                sb.append(this.conditionalOneVersusAll(category).toString() + "\n");
                sb.append("Average Conditional Probability Histogram=\n");
                this.appendCategoryLine(sb);
                for (j = 0; j < this.numCategories(); ++j) {
                    if (j > 0) {
                        sb.append(',');
                    }
                    sb.append(this.averageConditionalProbability(category, this.categories()[j]));
                }
                sb.append("\n");
            }
            if (!this.mHasJoint) continue;
            sb.append("Average Joint Probability Histogram=\n");
            this.appendCategoryLine(sb);
            for (j = 0; j < this.numCategories(); ++j) {
                if (j > 0) {
                    sb.append(',');
                }
                sb.append(this.averageLog2JointProbability(category, this.categories()[j]));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    void appendCategoryLine(StringBuilder sb) {
        sb.append("  ");
        for (int i = 0; i < this.numCategories(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.categories()[i]);
        }
        sb.append("\n  ");
    }

    private void validateCategory(String category) {
        if (this.mCategorySet.contains(category)) {
            return;
        }
        String msg = "Unknown category=" + category;
        throw new IllegalArgumentException(msg);
    }

    void rankHistogramToCSV(StringBuilder sb) {
        for (int i = 0; i < this.numCategories(); ++i) {
            if (i > 0) {
                sb.append('\n');
            }
            for (int rank = 0; rank < this.numCategories(); ++rank) {
                if (rank > 0) {
                    sb.append(',');
                }
                sb.append(this.mRankCounts[i][rank]);
            }
        }
    }

    double averageRankReference(int i) {
        double sum = 0.0;
        int count = 0;
        for (int rank = 0; rank < this.numCategories(); ++rank) {
            int rankCount = this.mRankCounts[i][rank];
            if (rankCount == 0) continue;
            count += rankCount;
            sum += (double)(rank * rankCount);
        }
        return sum / (double)count;
    }

    int categoryToIndex(String category) {
        int result = this.mConfusionMatrix.getIndex(category);
        if (result < 0) {
            String msg = "Unknown category=" + category;
            throw new IllegalArgumentException(msg);
        }
        return result;
    }

    int rankCount(int categoryIndex, int rank) {
        return this.mRankCounts[categoryIndex][rank];
    }

    public void addClassification(String referenceCategory, C classification, E input) {
        this.addClassificationOld(referenceCategory, classification);
        if (this.mStoreInputs) {
            this.mCases.add(input);
        }
    }

    public void addClassification(String referenceCategory, C classification) {
        this.addClassification(referenceCategory, classification, null);
    }

    private void addClassificationOld(String referenceCategory, C classification) {
        this.mConfusionMatrix.increment(referenceCategory, ((Classification)classification).bestCategory());
        this.mReferenceCategories.add(referenceCategory);
        this.mClassifications.add(classification);
        ++this.mNumCases;
        if (classification instanceof RankedClassification) {
            this.mHasRanked = true;
            this.addRanking(referenceCategory, (RankedClassification)classification);
        }
        if (classification instanceof ScoredClassification) {
            this.mHasScored = true;
            this.addScoring(referenceCategory, (ScoredClassification)classification);
        }
        if (classification instanceof ConditionalClassification) {
            this.mHasConditional = true;
            this.addConditioning(referenceCategory, (ConditionalClassification)classification);
        }
        if (classification instanceof JointClassification) {
            this.mHasJoint = true;
        }
    }

    final int numCategories() {
        return this.mConfusionMatrix.numCategories();
    }

    void addRanking(String refCategory, RankedClassification ranking) {
        this.updateRankHistogram(refCategory, ranking);
    }

    private void updateRankHistogram(String refCategory, RankedClassification ranking) {
        int refCategoryIndex = this.categoryToIndex(refCategory);
        if (ranking.size() < this.numCategories()) {
            this.mDefectiveRanking = true;
        }
        for (int rank = 0; rank < this.numCategories() && rank < ranking.size(); ++rank) {
            String category = ranking.category(rank);
            if (!category.equals(refCategory)) continue;
            int[] nArray = this.mRankCounts[refCategoryIndex];
            int n = rank;
            nArray[n] = nArray[n] + 1;
            return;
        }
        int[] nArray = this.mRankCounts[refCategoryIndex];
        int n = this.mCategories.length - 1;
        nArray[n] = nArray[n] + 1;
    }

    private void addScoring(String refCategory, ScoredClassification scoring) {
        if (scoring.size() < this.numCategories()) {
            this.mDefectiveScoring = true;
        }
        for (int rank = 0; rank < this.numCategories() && rank < scoring.size(); ++rank) {
            double score = scoring.score(rank);
            String category = scoring.category(rank);
            int categoryIndex = this.categoryToIndex(category);
            boolean match = category.equals(refCategory);
            ScoreOutcome outcome = new ScoreOutcome(score, match, rank == 0);
            this.mScoreOutcomeLists[categoryIndex].add(outcome);
        }
    }

    private void addConditioning(String refCategory, ConditionalClassification scoring) {
        if (scoring.size() < this.numCategories()) {
            this.mDefectiveConditioning = true;
        }
        for (int rank = 0; rank < this.numCategories() && rank < scoring.size(); ++rank) {
            double score = scoring.conditionalProbability(rank);
            String category = scoring.category(rank);
            int categoryIndex = this.categoryToIndex(category);
            boolean match = category.equals(refCategory);
            ScoreOutcome outcome = new ScoreOutcome(score, match, rank == 0);
            this.mConditionalOutcomeLists[categoryIndex].add(outcome);
        }
    }

    static class ScoreOutcome
    implements Scored {
        private final double mScore;
        private final boolean mOutcome;
        private final boolean mFirstBest;

        public ScoreOutcome(double score, boolean outcome, boolean firstBest) {
            this.mOutcome = outcome;
            this.mScore = score;
            this.mFirstBest = firstBest;
        }

        public double score() {
            return this.mScore;
        }

        public String toString() {
            return "(" + this.mScore + ": " + this.mOutcome + "firstBest=" + this.mFirstBest + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CaseComparator
    implements Comparator<Pair<?, ? extends Classification>> {
        private CaseComparator() {
        }

        @Override
        public int compare(Pair<?, ? extends Classification> p1, Pair<?, ? extends Classification> p2) {
            Classification c1 = p1.b();
            Classification c2 = p2.b();
            if (!(c1 instanceof ScoredClassification) || !(c2 instanceof ScoredClassification)) {
                return 0;
            }
            if (c1 instanceof ConditionalClassification && c2 instanceof ConditionalClassification) {
                return -Double.compare(((ConditionalClassification)c1).conditionalProbability(0), ((ConditionalClassification)c2).conditionalProbability(0));
            }
            return -Double.compare(((ScoredClassification)c1).score(0), ((ScoredClassification)c2).score(0));
        }
    }
}

