
/*******************************************************************/
/*                                                                 */
/*     File: bitop.h                                               */
/*   Author: Helmut Schmid                                         */
/*  Purpose:                                                       */
/*  Created: Fri Feb 13 15:04:24 2004                              */
/* Modified: Thu Jan 15 08:30:06 2009 (schmid)                     */
/*                                                                 */
/*******************************************************************/

#include <vector>
using std::vector;

const size_t LONG_BITS = sizeof(long) * 8;

inline size_t bitarray_size( size_t n ) {
  return (n + LONG_BITS - 1) / LONG_BITS;
};

inline bool get_bit( unsigned long *bitvec, size_t pos ) {
  size_t x = pos / LONG_BITS;
  size_t y = pos % LONG_BITS;
  return bitvec[x] & ((unsigned long)1 << y);
}

inline void set_bit( unsigned long *bitvec, size_t pos ) {
  size_t x = pos / LONG_BITS;
  size_t y = pos % LONG_BITS;
  bitvec[x] |= (unsigned long)1 << y;
}

void extract_bits(size_t b, size_t e, unsigned long *bitvec, vector<size_t> &m);

