/*
 * Decompiled with CFR 0.152.
 */
package util;

import settings.Parameters;

public class PrintProgress {
    private int index = 0;
    private int printEvery;

    public PrintProgress() {
        this("", 1, 0);
    }

    public PrintProgress(String startMessage) {
        this(startMessage, 1, 0);
    }

    public PrintProgress(String startMessage, int startIndex) {
        this(startMessage, 1, startIndex);
    }

    public PrintProgress(String startMessage, int printEvery, int startIndex) {
        if (this.index != 0) {
            this.end();
        }
        this.index = startIndex;
        this.printEvery = printEvery;
        Parameters.reportStringFlush(String.valueOf(startMessage) + "        ");
    }

    public void next() {
        ++this.index;
        this.checkIfTimeToPrint();
    }

    public void next(int toAdd) {
        this.index += toAdd;
        this.checkIfTimeToPrint();
    }

    private void checkIfTimeToPrint() {
        if (this.index % this.printEvery == 0) {
            int lastPrintedIndex = this.index == 0 ? 0 : this.index - this.printEvery;
            int backSpaces = lastPrintedIndex == 0 ? 0 : Integer.toString(lastPrintedIndex).length() + 1;
            int i = 0;
            while (i < backSpaces) {
                System.out.print("\b");
                ++i;
            }
            Parameters.reportStringFlush(String.valueOf(this.index) + " ");
        }
    }

    public void last() {
        if (this.index % this.printEvery != 0) {
            int lastPrintedIndex = this.index == 0 ? 0 : this.index - this.printEvery;
            int backSpaces = lastPrintedIndex == 0 ? 0 : Integer.toString(lastPrintedIndex).length() + 1;
            int i = 0;
            while (i < backSpaces) {
                System.out.print("\b");
                ++i;
            }
            Parameters.reportStringFlush(String.valueOf(this.index) + " ");
        }
    }

    public int currentIndex() {
        return this.index;
    }

    public void end() {
        this.end("...done");
    }

    public void end(String endMessage) {
        Parameters.reportLineFlush(" " + endMessage);
        this.index = 0;
    }
}

