/*
 * Decompiled with CFR 0.152.
 */
package tsg.parser;

import java.io.File;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Scanner;
import settings.Parameters;
import tsg.TSNode;
import tsg.corpora.Wsj;
import util.FileUtil;
import util.PrintProgressStatic;
import util.Utility;

public class PostProcess {
    public static void processFile(File inputFile, File output, boolean markHeads) {
        int sentence = 0;
        String section = "";
        Scanner scan = FileUtil.getScanner(inputFile);
        PrintWriter out = FileUtil.getPrintWriter(output);
        PrintProgressStatic.start("PostProcessing sentence:");
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.indexOf("No parse for: ") == 0) {
                ++sentence;
                PrintProgressStatic.next();
                out.write(String.valueOf(PostProcess.noParseDefault(line)) + "\n");
                section = "";
                continue;
            }
            if (line.equals("")) {
                if (section.equals("")) continue;
                ++sentence;
                PrintProgressStatic.next();
                out.write(String.valueOf(PostProcess.processSentence(section, markHeads)) + "\n");
                section = "";
                continue;
            }
            section = String.valueOf(section) + line + '\n';
        }
        PrintProgressStatic.end();
        scan.close();
        out.close();
    }

    public static String processSentence(String section, boolean markHeads) {
        if ((section = section.trim()).indexOf("No parse for: ") == 0) {
            return PostProcess.noParseDefault(section);
        }
        Hashtable<String, Double> parseSet = new Hashtable<String, Double>();
        String[] parses = section.split("\n");
        int i = 0;
        if (parses[0].startsWith("InsideProb:")) {
            ++i;
        }
        while (i < parses.length) {
            parses[i] = parses[i].replaceFirst("vitprob=", "");
            double prob = Double.parseDouble(parses[i]);
            TSNode TN = new TSNode(parses[++i]);
            TN.removeUniqueInternalLabels(markHeads);
            TN.fromNormalForm();
            if (Wsj.transformNPbasal) {
                TN.convertTag("NPB", "NP");
            }
            if (Wsj.transformSG) {
                TN.convertTag("SG", "S");
            }
            TN.removeRedundantRules();
            String parse = markHeads ? TN.toString(true, false) : TN.toString(false, false);
            Double newProb = (Double)parseSet.get(parse);
            newProb = newProb == null ? new Double(prob) : new Double(newProb + prob);
            parseSet.put(parse, newProb);
            ++i;
        }
        String maxParse = "";
        double maxProb = -1.0;
        Enumeration e = parseSet.keys();
        while (e.hasMoreElements()) {
            String parse = (String)e.nextElement();
            Double prob = (Double)parseSet.get(parse);
            if (!(prob > maxProb)) continue;
            maxProb = prob;
            maxParse = parse;
        }
        maxParse = Utility.replaceDoubleSlash(maxParse);
        maxParse = Utility.cleanSlash(maxParse);
        return maxParse;
    }

    public static int[] keepCovered(File testGoldComplete, File testGoldCovered, File testResultComplete, File testResultCovered) {
        Scanner scanGold = FileUtil.getScanner(testGoldComplete);
        Scanner scanResult = FileUtil.getScanner(testResultComplete);
        PrintWriter pwGold = FileUtil.getPrintWriter(testGoldCovered);
        PrintWriter pwResult = FileUtil.getPrintWriter(testResultCovered);
        int[] countCoveredTotal = new int[2];
        while (scanGold.hasNextLine() && scanResult.hasNextLine()) {
            String lineResult = scanResult.nextLine();
            String lineGold = scanGold.nextLine();
            countCoveredTotal[1] = countCoveredTotal[1] + 1;
            if (lineResult.startsWith("(TOP-X")) continue;
            countCoveredTotal[0] = countCoveredTotal[0] + 1;
            pwGold.println(lineGold);
            pwResult.println(lineResult);
        }
        scanGold.close();
        scanResult.close();
        pwGold.close();
        pwResult.close();
        return countCoveredTotal;
    }

    public static String noParseDefault(String sentence) {
        String defaultIntTag = "NNP";
        String defaultPostTag = "NP";
        sentence = sentence.replaceFirst("No parse for: ", "");
        sentence = Utility.removeDoubleQuotes(sentence).trim();
        String[] words = sentence.split(" ");
        sentence = "(TOP-X (" + defaultPostTag;
        int i = 0;
        while (i < words.length) {
            sentence = String.valueOf(sentence) + " (" + defaultIntTag + " " + words[i] + ") ";
            ++i;
        }
        sentence = sentence.trim();
        sentence = String.valueOf(sentence) + "))";
        return sentence;
    }

    public static void main(String[] args) {
        Parameters.setDefaultParam();
        if (args.length == 3) {
            PostProcess.processFile(new File(args[0]), new File(args[1]), Boolean.parseBoolean(args[2]));
        }
    }
}

