/*
 * Decompiled with CFR 0.152.
 */
package tsg.parser;

import java.util.PriorityQueue;
import tsg.parser.DerivationElement;
import tsg.parser.DerivationForest;

public class DerivationQueue {
    PriorityQueue<DerivationElement> queue = new PriorityQueue();
    DerivationForest leftForest;
    DerivationForest upForest;
    int split;
    boolean[][] accessMatrix;

    public DerivationQueue(DerivationForest leftForest, DerivationForest upForest, int split) {
        this.leftForest = leftForest;
        this.upForest = upForest;
        this.split = split;
        this.accessMatrix = new boolean[leftForest.size()][upForest.size()];
    }

    public DerivationElement pollFirst() {
        double logProbInitialPartial = this.leftForest.derivationLogProb[0] + this.upForest.derivationLogProb[0];
        int[] nArray = new int[5];
        nArray[0] = this.split;
        nArray[1] = this.leftForest.root;
        nArray[3] = this.upForest.root;
        int[] topIndexes = nArray;
        DerivationElement topQueueDerivation = new DerivationElement(topIndexes, logProbInitialPartial);
        this.accessMatrix[0][0] = true;
        return topQueueDerivation;
    }

    public DerivationElement addNeighboursAndPoll(DerivationElement topQueueDerivation) {
        this.addNeighbours(topQueueDerivation);
        return this.queue.poll();
    }

    public void addNeighbours(DerivationElement topQueueDerivation) {
        int currentIndexLeft = topQueueDerivation.indexes[2];
        int newIndexLeft = topQueueDerivation.indexes[2] + 1;
        int currentIndexUp = topQueueDerivation.indexes[4];
        int newIndexUp = topQueueDerivation.indexes[4] + 1;
        if (this.leftForest.size() != newIndexLeft && !this.accessMatrix[newIndexLeft][currentIndexUp]) {
            int[] newIndexLeftNeighbour = new int[]{this.split, this.leftForest.root, newIndexLeft, this.upForest.root, currentIndexUp};
            double newProbLeftNeighbourPartial = this.leftForest.derivationLogProb[newIndexLeft] + this.upForest.derivationLogProb[currentIndexUp];
            DerivationElement leftNeighbour = new DerivationElement(newIndexLeftNeighbour, newProbLeftNeighbourPartial);
            this.queue.add(leftNeighbour);
            this.accessMatrix[newIndexLeft][currentIndexUp] = true;
        }
        if (this.upForest.size() != newIndexUp && !this.accessMatrix[currentIndexLeft][newIndexUp]) {
            int[] newIndexUpNeighbour = new int[]{this.split, this.leftForest.root, currentIndexLeft, this.upForest.root, newIndexUp};
            double newProbUpNeighbourPartial = this.leftForest.derivationLogProb[currentIndexLeft] + this.upForest.derivationLogProb[newIndexUp];
            DerivationElement upNeighbour = new DerivationElement(newIndexUpNeighbour, newProbUpNeighbourPartial);
            this.queue.add(upNeighbour);
            this.accessMatrix[currentIndexLeft][newIndexUp] = true;
        }
    }
}

