[ROLE]
You are novice coder, and want to generate a user query exactly based on following guidelines. 
---
[INPUT]
You will be given `query`, `info`, and `updated_info`. This `query` is a command for generating a python code function. The `info` consists of extracted information from the `query` in JSON format. The `updated_info` consists of extra information over the `info`.
---
[TASK]
You need to generate `updated_query` with all information from the `updated_info` ONLY. For completing the task follow these METHOD step-by-step:-
[METHOD]
1. Understand how connection of `info` is set with the `query`. Learn the technique of how to phrase using the extracted `info` into a natural language human like `query`.
2. Translate this knowledge and generate `updated_query` just by using `updated_info`. While doing this keep the following in mind:-
- `updated_query` should NOT be exactly same as `query`
- DO NOT add any new information apart from `updated_query` in `updated_info`
- DO NOT alter/phrase/omit information that is in `updated_info`
- ALWAYS make sure for the information in `updated_info` has the same phrasing as in `query` for the `updated_query` for information that is same as in `info`

---

`query`: Write a python function to give product number in words all in lowercase, of an integer with first k items of two given lists using lambda function. If any list is empty, return '-'.
`info`: {"task": "product", "method": ["lambda function"], "input_type": ["integer","two lists"], "input_property": ["first k"], "output_type": ["in words"], "output_property": ["lowercase"], "edge_cases": {"any empty": "'-'"}}
`updated_info`: {"task": "product", "method": ["lambda function"], "input_type": ["integer","two lists"], "input_property": ["first k"], "output_type": ["in words"], "output_property": ["lowercase"], "edge_cases": {"any empty": "'-'"}}
`updated_query`: Write a python function to give product number in words all in lowercase, of an integer with first k items of two given lists using lambda function. If any list is empty, return '-'.
---

`query`: Write a function to return ascending sort on descending sorted list.
`info`: {"task": "sort", "method": [], "input_type": ["list"], "input_property": ["descending", "sorted"], "output_type": [], "output_property": ["ascending"], "edge_cases": {}}
`updated_info`: {"task": "sort", "method": [], "input_type": ["list"], "input_property": ["descending", "sorted"], "output_type": ["list"], "output_property": ["ascending"], "edge_cases": {}}
`updated_query`: Write a function to return ascending sorted list on descending sorted list.
---

`query`: Write a function to find largest number from a list.
`info`: {"task": "find", "method": [], "input_type": ["list"], "input_property": [], "output_type": ["number"], "output_property": ["largest"], "edge_cases": {}}
`updated_info`: {"task": "find", "method": [], "input_type": ["list"], "input_property": [], "output_type": ["number"], "output_property": ["largest"], "edge_cases": {}}
`updated_query`: Write a function to find largest number from a list.
---

`query`: Check if input is even.
`info`: {"task": "check", "method": [], "input_type": [], "input_property": [], "output_type": [], "output_property": ["even"], "edge_cases": {}}
`updated_info`: {"task": "check", "method": [], "input_type": ["number"], "input_property": [], "output_type": ["specific string"], "output_property": ["even"], "edge_cases": {"if True": "Even", "if False": "Not Even"}}
`updated_query`: Check if input of a given number is even. Return "Even" if True, else "Not Even" if False.
---

`query`: Return strings with longer words.
`info`: {"task": "filter", "method": [], "input_type": [], "input_property": [], "output_type": ["strings"], "output_property": ["longer"], "edge_cases": {}}
`updated_info`: {"task": "filter", "method": [], "input_type": ["list of strings"], "input_property": [], "output_type": ["list of strings"], "output_property": ["longer than 2"], "edge_cases": {}}
`updated_query`: Return list of strings with words longer than 2 for a given input of list of strings.
---

`query`: Find the maximum length of string.
`info`: {"task": "return", "method": [], "input_type": ["string"], "input_property": [], "output_type": [], "output_property": ["maximum length"], "edge_cases": {}}
`updated_info`: {"task": "return", "method": [], "input_type": ["list of strings"], "input_property": [], "output_type": ["number"], "output_property": ["maximum length"], "edge_cases": {"if empty list": "-1"}}
`updated_query`: Find the maximum length of string, for a list of strings input. If the list is empty return -1.
---

`query`: {{originalNL}}
`info`: {{info}}
`updated_info`: {{updated_info}}
`updated_query`: 