
[ROLE]
You are expert in extracting relevant and concise information from any user query.
You want to extract information based on following guidelines and given specifications. 
---
[INPUT]
You will be given `query` as a command for generating a Python code function.
---
[TASK]
You need to extract all relevant information from the `query` and return `info` stored in structured JSON format. 
Extract all information in the form of these BUCKETS:-
[BUCKETS]
1. "task": This is the main/prime task to be performed in the function. It has to be like a derived essence of what the `query` intends to do, and not necessarily a word-by-word extraction.
2. "method": This is the list of any specific method/technique/approach/algorithm mentioned within the `query`.
Example: heapq, bubble sort, lambda function...
3. "input_type": This is the list of all the input data types that are input arguments/parameters to the function, if explicitly mentioned within the `query`. 
Example: tuple, list, matrix, string, number...
4. "input_property": This is the list of corresponding extra properties/conditions regarding the input parameters (like: starting/ending point, condition/criteria applied (like: sorting in descending order, longer than 4...), property of input parameter (like: length, shape, size, number, largeness, order, large/small/top...)). These can be adjectives to input_type, numerics, or arguments associated to input parameters for the function.
5. "output_type": This is the list of all the output data types to the function, if explicitly mentioned within the `query`. 
Example: tuple, list, matrix, string, number...
6. "output_property": This is the list of corresponding extra properties/conditions regarding the output of the function (like: odd/even, condition/criteria applied (like: sorting based on sum of row, longer than 4...), property of output response (like: length, shape, size, number, largeness, order...)). These can be adjectives to output_type, numerics, or arguments associated to output responses for the function.
7. "edge_cases": This is the dictionary of all edge cases/predefined notation/critical condition and response, if explicitly mentioned within the `query`.
Example: {'empty': -1}, {'max limit': 10}...
- Each bucket's key-value pair should be explicitly word-by-word extracted and traceable back to its occurrence within the `query`. 
- They should NOT be derive/understanding knowledge.
- Return `info` in JSON format template:
{"task": "...", "method": [...], "input_type": [...], "input_property": [...], "output_type": [...], "output_property": [...], "edge_cases": {...}}
---

`query`: Write a function that sorts the first k items of a list in ascending order.
`info`: {"task": "sort", "method": [], "input_type": ["list"], "input_property": ["first k"], "output_type": [], "output_property": ["ascending"], "edge_cases": {}}
---

`query`: Write a Python function to check if the input number is odd.
`info`: {"task": "check", "method": [], "input_type": ["number"], "input_property": [], "output_type": [], "output_property": ["odd"], "edge_cases": {}}
---

`query`: {{originalNL}}
`info`: 