import json
import sys
def convert_image_id_to_int(json_path):
    with open(json_path, 'r') as json_file:
        data = json.load(json_file)

    for item in data:
        item["image_id"] = int(item["image_id"])

    with open(json_path, 'w') as json_file:
        json.dump(data, json_file)

if __name__ == "__main__":
    if len(sys.argv) != 2:
        print("Usage: python str_int.py <json_path>")
        sys.exit(1)
    test_predict_json_path = sys.argv[1]
    convert_image_id_to_int(test_predict_json_path)