/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.util;

import org.nustaq.serialization.util.FSTObject2IntMap;
import org.nustaq.serialization.util.FSTUtil;

public class FSTInt2ObjectMap<V> {
    public int[] mKeys;
    public Object[] mValues;
    public int mNumberOfElements;
    FSTInt2ObjectMap<V> next;
    private static final int GROWFAC = 2;

    public FSTInt2ObjectMap(int initialSize) {
        if (initialSize < 2) {
            initialSize = 2;
        }
        initialSize = FSTObject2IntMap.adjustSize(initialSize * 2);
        this.mKeys = new int[initialSize];
        this.mValues = new Object[initialSize];
        this.mNumberOfElements = 0;
    }

    public int size() {
        return this.mNumberOfElements + (this.next != null ? this.next.size() : 0);
    }

    public final void put(int key, V value) {
        int hash = key & Integer.MAX_VALUE;
        if (key == 0 && value == null) {
            throw new RuntimeException("key value pair not supported " + key + " " + value);
        }
        this.putHash(key, value, hash, this);
    }

    final void putHash(int key, V value, int hash, FSTInt2ObjectMap<V> parent) {
        int idx;
        if (this.mNumberOfElements * 2 > this.mKeys.length) {
            if (parent != null) {
                if ((parent.mNumberOfElements + this.mNumberOfElements) * 2 > parent.mKeys.length) {
                    parent.resize(parent.mKeys.length * 2);
                    parent.put(key, value);
                    return;
                }
                this.resize(this.mKeys.length * 2);
            } else {
                this.resize(this.mKeys.length * 2);
            }
        }
        if (this.mKeys[idx = hash % this.mKeys.length] == 0 && this.mValues[idx] == null) {
            ++this.mNumberOfElements;
            this.mValues[idx] = value;
            this.mKeys[idx] = key;
        } else if (this.mKeys[idx] == key) {
            this.mValues[idx] = value;
        } else {
            this.putNext(hash, key, value);
        }
    }

    final void putNext(int hash, int key, V value) {
        if (this.next == null) {
            int newSiz = this.mNumberOfElements / 3;
            this.next = new FSTInt2ObjectMap<V>(newSiz);
        }
        this.next.putHash(key, value, hash, this);
    }

    public final V get(int key) {
        int hash = key & Integer.MAX_VALUE;
        return this.getHash(key, hash);
    }

    final V getHash(int key, int hash) {
        int idx = hash % this.mKeys.length;
        int mKey = this.mKeys[idx];
        Object mValue = this.mValues[idx];
        if (mKey == 0 && mValue == null) {
            return null;
        }
        if (mKey == key) {
            return (V)mValue;
        }
        if (this.next == null) {
            return null;
        }
        return this.next.getHash(key, hash);
    }

    final void resize(int newSize) {
        newSize = FSTObject2IntMap.adjustSize(newSize);
        int[] oldTabKey = this.mKeys;
        Object[] oldTabVal = this.mValues;
        this.mKeys = new int[newSize];
        this.mValues = new Object[newSize];
        this.mNumberOfElements = 0;
        for (int n = 0; n < oldTabKey.length; ++n) {
            if (oldTabKey[n] == 0 && oldTabVal[n] == null) continue;
            this.put(oldTabKey[n], oldTabVal[n]);
        }
        if (this.next != null) {
            FSTInt2ObjectMap<V> oldNext = this.next;
            this.next = null;
            super.rePut(this);
        }
    }

    private void rePut(FSTInt2ObjectMap<V> kfstObject2IntMap) {
        for (int i = 0; i < this.mKeys.length; ++i) {
            int mKey = this.mKeys[i];
            if (mKey == 0 && this.mValues[i] == null) continue;
            kfstObject2IntMap.put(mKey, this.mValues[i]);
        }
        if (this.next != null) {
            super.rePut(kfstObject2IntMap);
        }
    }

    public void clear() {
        if (this.size() == 0) {
            return;
        }
        FSTUtil.clear(this.mKeys);
        FSTUtil.clear(this.mValues);
        this.mNumberOfElements = 0;
        if (this.next != null) {
            this.next.clear();
        }
    }
}

