/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.lmdbjni;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.fusesource.lmdbjni.Cursor;
import org.fusesource.lmdbjni.Entry;
import org.fusesource.lmdbjni.GetOp;
import org.fusesource.lmdbjni.SeekOp;

public class EntryIterator
implements Iterator<Entry>,
AutoCloseable {
    private final Cursor cursor;
    private final IteratorType type;
    private final byte[] key;
    private State state = State.NOT_READY;
    private Entry entry;
    private boolean first = true;

    EntryIterator(Cursor cursor, byte[] key, IteratorType type) {
        this.cursor = cursor;
        this.type = type;
        this.key = key;
    }

    @Override
    public boolean hasNext() {
        switch (this.state) {
            case DONE: {
                return false;
            }
            case READY: {
                return true;
            }
        }
        return this.tryToComputeNext();
    }

    private boolean tryToComputeNext() {
        if (this.first) {
            this.entry = this.key != null ? this.cursor.seek(SeekOp.RANGE, this.key) : (this.type == IteratorType.FORWARD ? this.cursor.get(GetOp.FIRST) : this.cursor.get(GetOp.LAST));
            this.first = false;
            if (this.entry == null) {
                this.state = State.DONE;
                return false;
            }
        } else {
            this.entry = this.type == IteratorType.FORWARD ? this.cursor.get(GetOp.NEXT) : this.cursor.get(GetOp.PREV);
            if (this.entry == null) {
                this.state = State.DONE;
                return false;
            }
        }
        this.state = State.READY;
        return true;
    }

    @Override
    public Entry next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        Entry result = this.entry;
        this.entry = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Iterable<Entry> iterable() {
        return new Iterable<Entry>(){

            @Override
            public Iterator<Entry> iterator() {
                return EntryIterator.this;
            }
        };
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    static enum IteratorType {
        FORWARD,
        BACKWARD;

    }

    private static enum State {
        READY,
        NOT_READY,
        DONE,
        FAILED;

    }
}

