import numpy as np
import matplotlib.pyplot as plt

scores=[]
with open('../logs/sd.log','r',encoding='utf-8') as f:
    for line in f.readlines():
        scores.append(float(line))

max_n = 500
step = 10
n_times_for_n = 1
means = []
variances = []
for n in range(1, max_n + 1, step):
    mean = 0
    variance = 0
    for _ in range(n_times_for_n):
        sample = np.random.choice(scores, n, replace=False)
        mean += np.mean(sample)
        variance += np.var(sample)
    means.append(mean / n_times_for_n)
    variances.append(variance / n_times_for_n)

# 绘制平均值和方差的折线图
plt.figure(figsize=(12, 6))

# 绘制平均值的折线图
plt.subplot(1, 2, 1)
plt.plot(range(1, max_n + 1, step), means, marker='o', color='b', label='Mean')
plt.title('Mean')
plt.xlabel('Number of Samples (n)')
plt.ylabel('Mean')
plt.grid(True)

# 绘制方差的折线图
plt.subplot(1, 2, 2)
plt.plot(range(1, max_n + 1, step), variances, marker='o', color='r', label='Variance')
plt.title('Variance')
plt.xlabel('Number of Samples (n)')
plt.ylabel('Variance')
plt.grid(True)

# 显示图例
plt.legend()

# 显示图形
plt.tight_layout()
plt.show()
